<?php
session_start();
include './includes/header.php';
?>
<!DOCTYPE html>
<html lang="en">
<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">
<link rel="stylesheet" href="assets/css/tree-style.css">
<body>
<div class="container-scroller">
    <?php include './includes/profilebasenavbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
        <?php include './includes/sidebarmenu.php'; ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel">
                                    <p id="departmentError" class="container form-container error-message text-center" style="color: red; font-weight: 900; font-size: 18px; display: none;"></p>

                                    <div class="container form-container" style="width:103%;margin-left: -3%;">
                                        <!-- <div class="alert alert-info" role="alert">
                                                <strong>Note:</strong> This module is currently under development and some features may not be fully functional.
                                            </div> -->
                                        <h2>🚢 Continue Draft Requisition</h2>
                                        <form id="requestForm" class="mt-3">
                                            <div class="row">
                                                <div class="col-md-4">
                                                    <div class="tree-card">
                                                        <div class="requisition-type" style="display: flex; justify-content: space-between; align-items: center;">
                                                            <div>
                                                                <label><strong>Select Requisition Type <span style="color:red">*</span></strong></label><br>
                                                                <input type="radio" id="spare" name="requisitionType" value="Spare" onchange="handleRequisitionTypeChange()">
                                                                <label for="1">Spare</label>
                                                                <input type="radio" id="store" name="requisitionType" value="Store" onchange="handleRequisitionTypeChange()">
                                                                <label for="2">Store</label>
                                                            </div>
                                                            <button type="button" class="btn btn-outline btn-sm" onclick="location.reload();" style="font-size: 12px; color: #007bff;">
                                                                <i class="fa fa-refresh"></i> Refresh
                                                            </button>
                                                        </div>

                                                        <div id="searchContainer" class="mt-2" style="display: none;">
                                                            <input type="text" placeholder="🔍 Search..." class="search-box" onkeyup="searchTree(this.value)">
                                                        </div>
                                                        
                                                        
                                                        <div id="treeLoader" style="display: none; margin: 10px auto; text-align: center;">
                                                            <div class="ship-loader">
                                                                <div class="water">
                                                                <i class="fa fa-ship ship-icon"></i>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <ul id="tree" class="tree"></ul>
                                                    </div>
                                                </div>

                                                <div class="col-md-8">
                                                    <div class="tree-card">
                                                        <div class="col-md-12 text-end">
                                                            <h6 style="text-decoration: underline;">Date:
                                                                <?php echo date('d-m-Y'); ?>
                                                            </h6>
                                                        </div>
                                                        
                                                        <div class="row g-3" id="initialFields">
                                                            
                                                            <div class="col-md-6">
                                                                <label for="vesselName"><strong>Vessel Name</strong></label>
                                                                <input type="text" id="vesselName" name="vessel_name" value="<?php echo  $_SESSION['ship_name'] ; ?>" class="form-control" disabled style="background-color:white;">
                                                            </div>
                                                            <div class="col-md-6" id="departmentDiv">
                                                                <label for="departmentSelect"><strong>Department Name <span style="color:red">*</span></strong></strong></label>
                                                                <select id="departmentSelect" name="department_id" class="form-control" onchange="handleDepartmentChange()" disabled style="background-color:white;">
                                                                    <option value="" selected disabled>Select Department</option>
                                                                </select>
                                                            </div>
                                                            
                                                        </div>

                                                        <!-- Spare fields -->
                                                        <div class="row g-3 mt-1" id="spareFields">
                                                            <div class="col-md-6">
                                                                <label for="requisitionNumber"><strong>Requisition Number <span style="color:red">*</span></strong></strong></label>
                                                                <input type="text" id="requisitionNumber" name="requisition_number" placeholder="Enter Requisition No." class="form-control" required disabled style="background-color:white;">
                                                            </div>
                                                            <div class="col-md-6" id = "engineDiv">
                                                                <label for="engineDropdown"><strong>Equipment Name/Engine Type</strong></label>
                                                                <input type="text" id="engineDropdown" name="engine_type_id" placeholder="Enter Equipment Name" class="form-control" disabled style="background-color:white;">
                                                            </div>

                                                            <div class="col-md-6" id = "modelDiv">
                                                                <label for="modelType"><strong>Model / Type</strong></label>
                                                                <input type="text" id="modelType" name="model_type" placeholder="Enter Model/Type" class="form-control" disabled style="background-color:white;">
                                                            </div>
                                                            <div class="col-md-6" id = "makerDiv">
                                                                <label for="makerName"><strong>Maker Details</strong></label>
                                                                <input type="text" id="makerName" name="maker_name" placeholder="Enter Maker Name" class="form-control" disabled style="background-color:white;">
                                                            </div>
                                                            <div class="col-md-6" id = "serialNoDiv">
                                                                <label for="serialNo"><strong>Serial No</strong></label>
                                                                <input type="text" id="serialNo" name="serial_no" placeholder="Enter Serial No" class="form-control" disabled style="background-color:white;">
                                                            </div>
                                                            
                                                            <div class="col-md-6" id = "priorityDiv">
                                                                <label for="priority"><strong>Priority Level</strong></label>
                                                                <select name="priority" id="priority" class="form-control" disabled style="background-color:white;">
                                                                    <option value="1">Normal</option>
                                                                    <option value="2">Urgent</option>
                                                                </select>
                                                            </div>
                                                            
                                                            <input type="hidden" id="modelMakerId" name="model_maker_id" class="form-control">
                                                        </div>
                                                        <div class="row g-3 mt-1">
                                                            <div class="col-md-12">
                                                                <label for="remark"><strong>Remark</strong></label>
                                                                <textarea id="remark" name="remark" rows="2" placeholder="Enter any remarks here" class="form-control" disabled style="background-color:white;"></textarea>
                                                            </div>
                                                        </div>

                                                        <!-- Store-specific fields -->
                                                        <div class="row g-3 mt-1" id="storeFields" style="display: none;">
                                                            <!-- <div class="col-md-6">
                                                                <label for="priorityStore"><strong>Priority Level</strong></label>
                                                                <select name="priority" id="priorityStore" class="form-control">
                                                                    <option value="Normal">Normal</option>
                                                                    <option value="Urgent">Urgent</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-md-6">
                                                                <label for="serialNoStore"><strong>Serial No</strong></label>
                                                                <input type="text" id="serialNoStore" name="serial_no" placeholder="Enter Serial No" class="form-control">
                                                            </div> -->
                                                        </div>

                                                    </div>
                                                </div>
                                                <div id="itemTableSection" style="display: none;">
                                                    <h3 style="font-size: 14px; margin-bottom: 10px;"><strong>Item Details List</strong></h3>
                                                    <table id="itemDetailsTable" class="datatable" style="width: 100%; font-size: 12px;">
                                                        <thead>
                                                            <tr>
                                                                <th style="width: 5%; padding: 6px 8px; text-align: center;">Sr. No.</th>
                                                                <th style="width: 15%; padding: 6px 8px; text-align: center;">Item Name</th>
                                                                <th style="width: 10%; padding: 6px 8px; text-align: center;">Drawing No.</th>
                                                                <th style="width: 10%; padding: 6px 8px; text-align: center;">Part No./IMPA Code</th>
                                                                <th style="width: 7%; padding: 6px 8px; text-align: center;">Working Qty</th>
                                                                <th style="width: 7%; padding: 6px 8px; text-align: center;">ROB</th>
                                                                <th style="width: 7%; padding: 6px 8px; text-align: center;">Req Qty <strong><span style="color:red">*</span></strong></th>
                                                                <th style="width: 7%; padding: 6px 8px; text-align: center;">Units</th>
                                                                <th style="width: 10%; padding: 6px 8px; text-align: center;">Remarks</th>
                                                                <th style="width: 10%; padding: 6px 8px; text-align: center;">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody></tbody>
                                                    </table>
                                                </div>
                                                
                                                <div class="col-md-12 text-center mt-2"style="margin-bottom:-25px;">
                                                    <button class="btn btn-outline-primary btn-fw" type="button" onclick="validateAndConfirmDraft('<?php echo $_GET['req_id']; ?>')">Save as Draft</button>
                                                    <button class="btn btn-outline-success btn-fw" type="button" onclick="validateAndConfirmSubmission();">Submit Request</button>
                                                </div>

                                            </div>
                                        </form>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
    </div>
</div>

<!-- Modal: Save as Draft Confirmation -->
<div class="modal-overlay" id="confirmDraft" style="display: none;">
    <div class="modal-box">
        <div class="modal-header">
            Save Requisition as Draft
            <button onclick="closeConfirmSubmission('confirmDraft');" style="width: 10%;">&times;</button>
        </div>
        <div class="modal-body">
            Are you sure you want to save this requisition as a draft? If confirmed, it will be available in the "Draft Requisitions" section. You can continue and submit it later.
            <div class="modal-body text-center mt-1">
                <button class="btn btn-outline-info btn-sm" onclick="closeConfirmSubmission('confirmDraft');">Cancel</button>
                <button class="btn btn-outline-primary btn-sm" onclick="performSaveAsDraft();">Confirm</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Confirm Submission -->
<div class="modal-overlay" id="confirmSubmission" style="display: none;">
    <div class="modal-box">
        <div class="modal-header">
            Final Submission Confirmation
            <button onclick="closeConfirmSubmission('confirmSubmission');" style="width: 10%;">&times;</button>
        </div>
        <div class="modal-body">
            Are you sure you want to submit this requisition? This is the final review. Once submitted, no more items can be added to this requisition.
            <div class="modal-body text-center mt-1">
                <button class="btn btn-outline-info btn-sm" onclick="closeConfirmSubmission('confirmSubmission');">Cancel</button>
                <button class="btn btn-outline-success btn-sm" onclick="performFinalSubmission();">OK</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal: Submission Successful -->
<div class="modal-overlay" id="submissionSuccess" style="display: none;">
    <div class="modal-box">
        <div class="modal-body text-center">
            <h5 class="modal-title">Requisition submitted successfully!</h5>
            <div class="modal-body text-center">
                <button class="btn btn-outline-success btn-sm" onclick="window.location.href = 'index.php';">OK</button>
            </div>
        </div>
    </div>
</div>


<?php include './includes/dependancy.php'; ?>
<script src="assets/js/tree_script_for_draft.js"></script>
    <script>
        function getReqIdFromURL() {
        const params = new URLSearchParams(window.location.search);
        return params.get('req_id');
        }

        $(document).ready(function () {
            const req_id = getReqIdFromURL();
            if (req_id) {
                loadDraftRequisition(req_id);
            } else {
                alert("Missing requisition ID.");
            }
        });

    </script>

</body>
</html>