<?php
/*
    API: Fetch Draft Requisition
    Version: 1.2
    Updated: 2025-05-28
*/

session_start();
require_once '../config/config.php';
header('Content-Type: application/json');

function logError($label, $data) {
    file_put_contents(__DIR__ . '/debug_log.txt', "[$label] " . print_r($data, true) . "\n", FILE_APPEND);
}

$data = json_decode(file_get_contents("php://input"), true);
$req_id = isset($data['req_id']) ? (int)$data['req_id'] : 0;

if ($req_id <= 0) {
    echo json_encode(['error_code' => 400, 'message' => 'Invalid req_id']);
    exit;
}

$conn = SqlServerConnection::getConnection();
if ($conn === false) {
    logError('SQL Connection Failed', sqlsrv_errors());
    echo json_encode(['error_code' => 500, 'message' => 'SQL Server connection failed']);
    exit;
}

// Fetch header
$headerSQL = "SELECT req_id, req_no, ship_id, dept_id, req_serial_no, req_for, req_priority, req_status, req_eq_name_engine_type, req_model_type, req_maker_name, req_maker_address, req_remark, req_date_of_creation, user_id FROM requisition_header_all WHERE req_id = $req_id";
$headerResult = sqlsrv_query($conn, $headerSQL);

if (!$headerResult || !($headerRow = sqlsrv_fetch_array($headerResult, SQLSRV_FETCH_ASSOC))) {
    logError('Header Fetch Failed', sqlsrv_errors());
    echo json_encode(['error_code' => 404, 'message' => 'Requisition header not found']);
    exit;
}

// Fetch item data
$itemSQL = "SELECT * FROM item_requisition_header_all WHERE req_id = $req_id";
$itemResult = sqlsrv_query($conn, $itemSQL);

if (!$itemResult) {
    logError('Item Fetch Failed', sqlsrv_errors());
    echo json_encode(['error_code' => 405, 'message' => 'Item details not found']);
    exit;
}

$items = [];
$item_id_array = [];

while($itemRow = sqlsrv_fetch_array($itemResult, SQLSRV_FETCH_ASSOC)) {
for ($i = 1; $i <= 40; $i++) {

   if ($itemRow["item_id_$i"] === null || $itemRow["item_id_$i"] === '') {
        break;
    }

    $jsonField = $itemRow["item_details_$i"] ?? null;


    if ($jsonField && strtolower($jsonField) !== 'null') {
        $decoded = json_decode($jsonField, true);
        if (is_array($decoded) && isset($decoded['item_id'])) {
            $cat_id = (int)$decoded['cat_id'];
            if($decoded['status'] == 'A') {
                $item_id = (int)$decoded['item_id'];
                
                $item_id_array [] = $decoded['item_id'];

                $itemNameSQL = "SELECT item_name FROM item_header_all WHERE item_id = $item_id";
                $itemNameResult = sqlsrv_query($conn, $itemNameSQL);
                if ($itemNameResult && ($itemNameRow = sqlsrv_fetch_array($itemNameResult, SQLSRV_FETCH_ASSOC))) {
                    $decoded['item_name'] = $itemNameRow['item_name'];
                } else {
                    $decoded['item_name'] = ''; 
                }

                $items[] = $decoded;
            }
            
        }
    }
}
}






// Return successful response
$response = [
    'error_code' => 200,
    'message' => 'Draft requisition fetched successfully',
    'header' => $headerRow,
    'items' => $items,
    'cat_id' => $cat_id,
    'item_id_array' => $item_id_array 
];

echo json_encode($response, JSON_UNESCAPED_UNICODE);
