<?php
session_start();
require_once '../config/config.php';

// Get the database connection
$conn = SqlServerConnection::getConnection();

// Clean output buffer and set headers
ob_clean();
header('Content-Type: application/json');

// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$token_id = $headers['token_id'] ?? null;
$mode = $headers['mode'] ?? null;

$user_id = $_SESSION['user_id'] ?? null;
$user_token = $_SESSION['user_token'] ?? null;

// Validate session token
if (!$user_id) {
    session_destroy();
    echo json_encode(['error_code' => 900, 'message' => 'Ses98998sion expired']);
    exit;
}

$query = "SELECT user_token FROM user_header_all WHERE user_id = ?";
$params = [$user_id];
$stmt = sqlsrv_query($conn, $query, $params);

if ($stmt === false || !($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))) {
    session_destroy();
    echo json_encode(['error_code' => 900, 'message' => 'Session 777 expired']);
    exit;
}

// Default response
$response = ['error_code' => 300];

// Process POST request
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($mode == 1) {
        if (!isset($_POST['ship_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }

        $ship_id = trim($_POST['ship_id']);

        // Get request statuses
        $query = "SELECT req_status FROM requisition_header_all WHERE ship_id = ?";
        $params = [$ship_id];
        $stmt = sqlsrv_query($conn, $query, $params);

        $partial = $pending = $accepted = $rejected = $return = $operative = $complete = 0;

        if ($stmt) {
            while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
                switch ($row['req_status']) {
                    case 0: $partial++; break;
                    case 1: $pending++; break;
                    case 2: $accepted++; break;
                    case 3: $rejected++; break;
                    case 4: $return++; break;
                    case 5: $operative++; break;
                    case 6: $complete++; break;
                }
            }

            // Get last 15 days requests
            $last_15_days = date('Y-m-d', strtotime('-15 days'));
            $query = "SELECT * FROM requisition_header_all 
                      WHERE ship_id = ? AND req_date_of_creation >= ?";
            $params = [$ship_id, $last_15_days];
            $stmt_recent = sqlsrv_query($conn, $query, $params);

            $items = [];
            if ($stmt_recent) {
                while ($row = sqlsrv_fetch_array($stmt_recent, SQLSRV_FETCH_ASSOC)) {
                    $items[] = $row;
                }
            }

            $response = [
                'error_code' => 200,
                'message' => 'Data retrieved successfully',
                'data' => $items,
                'status_counts' => [
                    'partial' => $partial,
                    'pending' => $pending,
                    'accepted' => $accepted,
                    'rejected' => $rejected,
                    'return' => $return,
                    'operative' => $operative,
                    'complete' => $complete
                ]
            ];
        } else {
            $response = ['error_code' => 500, 'message' => 'Query execution failed'];
        }
    }
}

// Return JSON response
echo json_encode($response);
?>
