<?php 
session_start();
require_once '../config/config.php';

$conn = SqlServerConnection::getConnection();

ob_clean();
header('Content-Type: application/json');

$headers = function_exists('getallheaders') ? getallheaders() : [];
$mode = $headers['mode'] ?? null;

$response = ['error_code' => 300];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if ($mode == 1) {
        $dept_id = intval($_POST['dept_id']); 

        $query_for_department = "SELECT dept_name FROM department_header_all WHERE dept_id = $dept_id";
        $stmt_for_department = sqlsrv_query($conn, $query_for_department);

        if ($stmt_for_department === false) {
            $errors = sqlsrv_errors();
            $response['error_code'] = 400;
            $response['message'] = "Error fetching department: " . print_r($errors, true);
            echo json_encode($response);
            exit;
        }

        $row_dept_details = sqlsrv_fetch_array($stmt_for_department, SQLSRV_FETCH_ASSOC);
        $dept_name = $row_dept_details['dept_name'];
        $formatted_name = strtoupper(substr($dept_name, 0, 1)); 
        $year = date('y'); 

        $check_query = "SELECT u_no FROM unique_id_header_all 
                        WHERE u_table_name = 'requisition_header_all' AND dept_id = $dept_id";
        $check_stmt = sqlsrv_query($conn, $check_query);

        if ($check_stmt === false) {
            $response['error_code'] = 500;
            $response['message'] = "Error checking existing requisition: " . print_r(sqlsrv_errors(), true);
            echo json_encode($response);
            exit;
        }

        $existing_row = sqlsrv_fetch_array($check_stmt, SQLSRV_FETCH_ASSOC);

        if ($existing_row) {
            $req_no = intval($existing_row['u_no']) + 1;
            
        } else {
            $req_no = 1;
            $insert_query = "INSERT INTO unique_id_header_all 
                             (u_table_name, u_no, u_date_of_creation, dept_id) 
                             VALUES ('requisition_header_all', $req_no, GETDATE(), $dept_id)";
            $insert_stmt = sqlsrv_query($conn, $insert_query);

            if ($insert_stmt === false) {
                $response['error_code'] = 500;
                $response['message'] = "Error inserting new requisition number: " . print_r(sqlsrv_errors(), true);
                echo json_encode($response);
                exit;
            }
        }

        $req_no_str = $formatted_name . '-' . str_pad($req_no, 3, '0', STR_PAD_LEFT) . '/' . $year;
        $response = ['error_code' => 200, 'req_no' => $req_no_str];
    }
}

echo json_encode($response);
?>
