<?php
/*
Objective: for report

File Version: 1.0  
API NO: SBK02  
Date of Creation: 04/04/2025  

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  

Logic Zone:  

Date: 04/04/2025  

Request Method:  
Type: POST  

Headers:  
- `Content-Type: application/json`  
- `token_id` (required) - User session token for authentication.  
- `mode` (required) - Determines the type of data to fetch.  

Request Parameters (Based on `mode`):  

### Mode 1 - Fetch Requisition Details  
Required Parameters:  
- `ship_id` (string, required) – The ID of the ship.  
- `form_date` (date, optional) – The starting date for requisition filtering.  
- `to_date` (date, optional) – The ending date for requisition filtering.  
- `req_type` (string, optional) – The type of requisition.  
- `dept` (string, optional) – The department ID.  

### Mode 2 - Fetch Department Details  
No additional parameters required.  

### Mode 3 - Fetch Detailed Requisition Information  
Required Parameter:  
- `req_id` (integer, required) – The ID of the requisition.  

If any required parameter is missing, the API returns an error response.  

***********  

### Authentication Process  

#### Step 1: Token Verification  
- The API retrieves the `user_token` from the database based on `user_id`.  
- If the session token does not match, the session is destroyed, and an error response is returned.  

#### Step 2: Fetch Data Based on `mode`  

##### **Mode 1: Fetch Requisition Details**  
- Validates required fields (`ship_id`, `form_date`, `to_date`, `req_type`, `dept`).  
- Constructs a SQL query to retrieve requisition details, including:  
  - `req_id`, `req_no`, `user_name`, `req_status`, `dept_name`  
- Filters data based on dates, requisition type, and department.  
- Fetches related purchase order (PO) details linked to the requisition.  
- Returns requisition details along with the total number of linked POs.  

##### **Mode 2: Fetch Department Details**  
- Executes a query to fetch all departments (`dept_id`, `dept_name`).  
- Returns the department list.  

##### **Mode 3: Fetch Requisition Item Details**  
- Validates `req_id`.  
- Retrieves requisition details, including:  
  - `req_serial_no`, `req_priority`, `ship_name`, `dept_name`, `cat_name`, `eq_name`, `model_name`, `maker_name`, `user_name`.  
- Fetches purchase order details related to the requisition.  
- Fetches ordered item details from the requisition.  
- Retrieves vendor details and related item information.  
- Returns requisition details, vendor details, and item details.  

********  

### Response Structure  

#### Success Response  
If data is retrieved successfully, the API returns:  
- `error_code: 200` (indicating success).  
- `message`: "Data retrieved successfully".  
- `data`: The requested details.  

#### Failure Responses  

| Condition | `error_code` | `message` |
|-----------|-------------|-----------|
| Missing required fields | 300 | "Missing required fields" |
| Invalid session token | 900 | "Session expired" |
| No data found | 400 | "No data found" |
| Internal Server Error | 500 | No message |

-------------------------------------------------------------------------------------------------------------------------------  

Date: 04/04/2025  

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx  

Error Zone:  

Date: 04/04/2025  

*/ 


session_start();
require_once '../config/config.php';
// Get the database connection
$conn = connection::getConnection();
// Set response header to return JSON
ob_clean();
header('Content-Type: application/json');
// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$token_id = $headers['token_id'] ?? null;
$mode = $headers['mode'] ?? null;
// $user_id = $_SESSION['user_id'];
// $query_for_get_user_token = "SELECT user_token FROM user_header_all WHERE user_id = '$user_id'";
// $result_for_get_user_token = mysqli_query($conn, $query_for_get_user_token);
// if ($result_for_get_user_token) {
//     $row = mysqli_fetch_assoc($result_for_get_user_token);
//     if (!$row || $row['user_token'] !== $_SESSION['user_token']) {
//         // Token mismatch - clear session
//         session_destroy();
//         echo json_encode(['error_code' => 900, 'message' => 'session expired']);
//         exit;
//     }
// }
// Default response
$response = ['error_code' => 300];
// Check request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if required fields exist
    if($mode == 1){
        if (!isset($_POST['ship_id']) || !isset($_POST['form_date']) || !isset($_POST['to_date']) || !isset($_POST['req_type']) || !isset($_POST['dept'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        // Sanitize user inputs
        $ship_id = mysqli_real_escape_string($conn, trim($_POST['ship_id'] ?? ''));
        $from_date = isset($_POST['form_date']) ? mysqli_real_escape_string($conn, trim($_POST['form_date'])) : null;
        $to_date = isset($_POST['to_date']) ? mysqli_real_escape_string($conn, trim($_POST['to_date'])) : date('Y-m-d');
        $req_type = isset($_POST['req_type']) && $_POST['req_type'] !== 'all' ? mysqli_real_escape_string($conn, trim($_POST['req_type'])) : null;
        $dept = isset($_POST['dept']) && $_POST['dept'] !== 'all' ? mysqli_real_escape_string($conn, trim($_POST['dept'])) : null;
        
        $query_for_get_req = "SELECT r.req_id, r.req_no, u.user_name, r.req_status, d.dept_name 
                              FROM requisition_header_all r 
                              LEFT JOIN user_header_all u ON r.user_id = u.user_id 
                              LEFT JOIN department_header_all d ON r.dept_id = d.dept_id 
                              WHERE r.ship_id = '$ship_id'";
        
        // Date Conditions
        if (!empty($from_date) && !empty($to_date)) {
            $query_for_get_req .= " AND r.item_date_of_creation BETWEEN '$from_date' AND '$to_date'";
        } elseif (!empty($from_date)) {
            $query_for_get_req .= " AND r.item_date_of_creation >= '$from_date'";
        } elseif (!empty($to_date)) {
            $query_for_get_req .= " AND r.item_date_of_creation <= '$to_date'";
        }
        
        // Other Conditions
        if (!empty($req_type)) {
            $query_for_get_req .= " AND r.req_status = '$req_type'";
        }
        if (!empty($dept)) {
            $query_for_get_req .= " AND r.dept_id = '$dept'";
        }
        $result_for_get_req = $conn->query($query_for_get_req);
        $req_details = [];
        if ($result_for_get_req && mysqli_num_rows($result_for_get_req) > 0) {
            while ($row_req_details = mysqli_fetch_assoc($result_for_get_req)) {
                $req_id = $row_req_details['req_id'];
                $items = []; 
                $query_for_get_po_count = "SELECT po_id, req_id FROM po_vendor_header_all WHERE req_id = '$req_id'";
                $result_for_get_po_count = $conn->query($query_for_get_po_count);
                if ($result_for_get_po_count && $result_for_get_po_count->num_rows > 0) {
                    while ($row = $result_for_get_po_count->fetch_assoc()) {
                        $items[] = $row; 
                    }
                }
                $req_info = [
                    'req_id' => $row_req_details['req_id'],
                    'req_no' => $row_req_details['req_no'],
                    'user_name' => $row_req_details['user_name'],
                    'dept_name' => $row_req_details['dept_name'],
                    'req_status' => $row_req_details['req_status'],
                    'total_po' => count($items)
                ];
                $req_details[] = $req_info; 
            }
            $response = [
                'error_code' => 200,
                'message' => 'Data retrieved successfully',
                'total_req' => count($req_details),
                'data' => $req_details
            ];
        } else {
            $response = [
                'error_code' => 500
            ];
        }
    }
    if($mode == 2) {
        $query_for_department = "SELECT dept_id, dept_name FROM department_header_all";
        $result_for_department = $conn->query($query_for_department);
        $dept_details = [];
        
        if ($result_for_department && mysqli_num_rows($result_for_department) > 0) {
            while ($row_dept_details = mysqli_fetch_assoc($result_for_department)) {
                $dept_details[] = $row_dept_details; 
            }
            $response = [
                'error_code' => 200,
                'data' => $dept_details,
            ];
        } else {
            $response = [
                'error_code' => 500
            ];
        }
    }   
    
    if ($mode == 3) {
        if (!isset($_POST['req_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
    
        // Sanitize user inputs
        $req_id = mysqli_real_escape_string($conn, $_POST['req_id']);
        $query_for_get_req_details = "SELECT r.req_serial_no, r.req_priority, s.ship_no, s.ship_name, d.dept_no, d.dept_name, c.cat_id, c.cat_name, e.eq_name, e.eq_engine_type, m.model_name, m.maker_name, m.maker_address, u.user_name 
                                      FROM requisition_header_all r 
                                      LEFT JOIN ship_header_all s ON r.ship_id = s.ship_id 
                                      LEFT JOIN department_header_all d ON r.dept_id = d.dept_id 
                                      LEFT JOIN category_header_all c ON r.cat_id = c.cat_id 
                                      LEFT JOIN equipment_header_all e ON r.eq_id = e.eq_id 
                                      LEFT JOIN modal_maker_header_all m ON r.m_id = m.m_id 
                                      LEFT JOIN user_header_all u ON r.user_id = u.user_id 
                                      WHERE r.req_id = '$req_id'";
    
        $result_for_get_req_details = mysqli_query($conn, $query_for_get_req_details);
        
        if ($result_for_get_req_details && mysqli_num_rows($result_for_get_req_details) == 1) {
            $row_req_details = mysqli_fetch_assoc($result_for_get_req_details);
            $cat_id = $row_req_details['cat_id'];
    
            $query_for_po_details = "SELECT p.po_id, v.ven_name, v.ven_address 
                                     FROM po_vendor_header_all p 
                                     LEFT JOIN vendor_header_all v ON p.ven_id = v.ven_id  
                                     WHERE p.req_id = $req_id";
            $result_for_po_details = mysqli_query($conn, $query_for_po_details);
            $po_item_details = [];
    
            if (mysqli_num_rows($result_for_po_details) > 0) {
                while ($row_result_for_po_details = mysqli_fetch_assoc($result_for_po_details)) {
                    $vendor_data = [
                        "po_id" => $row_result_for_po_details['po_id'],
                        "vendor_name" => $row_result_for_po_details['ven_name'],
                        "vendor_address" => $row_result_for_po_details['ven_address'],
                        "items" => []  // Nested array for items
                    ];
    
                    $po_id = $row_result_for_po_details['po_id'];
    
                    // Fetch items related to the vendor
                    $query_items = "SELECT * FROM po_item_details_all WHERE po_id = '$po_id' AND req_id = $req_id";
                    $result_items = mysqli_query($conn, $query_items);
    
                    if ($result_items && mysqli_num_rows($result_items) > 0) {
                        $poi_items = [];
                        while ($row_item = mysqli_fetch_assoc($result_items)) {
                            for ($i = 1; $i <= 15; $i++) {
                                if (!empty($row_item["poi_item_id_$i"])) {
                                    $poi_item_details = json_decode($row_item["poi_item_id_$i"]);
                                    $poi_last_item = end($poi_item_details);
                                    $item_id = $poi_last_item->item_id;
    
                                    $query_for_get_item_details = "SELECT item_id, item_name, item_drawing_no, item_part_no 
                                                                   FROM item_header_all 
                                                                   WHERE item_id = '$item_id'";
                                    $result_for_get_item_details = mysqli_query($conn, $query_for_get_item_details);
                                    $row_item_details = mysqli_fetch_assoc($result_for_get_item_details);
    
                                    $poi_item_details_for_perticuler_item = [
                                        "item_id" => $poi_last_item->item_id,
                                        "item_name" => $row_item_details['item_name'],
                                        "item_drawing_no" => $row_item_details['item_drawing_no'],
                                        "item_part_no" => $row_item_details['item_part_no'],
                                        "ordered_qty" => $poi_last_item->ordered_qty,
                                        "rate" => $poi_last_item->rate,
                                        "currency" => $poi_last_item->currency,
                                    ];
                                    $poi_items[] = [
                                        "item_details" => $poi_item_details_for_perticuler_item
                                    ];
                                }
                            }
                        }
                        $poi_item_details = [
                            "vendor_name" => $row_result_for_po_details['ven_name'],
                            "vendor_address" => $row_result_for_po_details['ven_address'],
                            "poi_items" => $poi_items
                        ];
                    }
                    $po_item_details[] = $poi_item_details;
                }
            }
    
            $query_for_get_items_from_req = "SELECT * FROM item_requisition_header_all WHERE req_id = '$req_id'";
            $result_for_get_items_from_req = mysqli_query($conn, $query_for_get_items_from_req);
            $data = [];
    
            if ($result_for_get_items_from_req && mysqli_num_rows($result_for_get_items_from_req) > 0) {
                while ($row = mysqli_fetch_assoc($result_for_get_items_from_req)) {
                    $sub_cat_id = $row['sub_cat_id'];
    
                    $query_for_get_sub_cat_name = "SELECT sub_cat_name FROM sub_category_header_all WHERE sub_cat_id = '$sub_cat_id'";
                    $result_for_get_sub_cat_name = mysqli_query($conn, $query_for_get_sub_cat_name);
                    $row_sub_cat_name = mysqli_fetch_assoc($result_for_get_sub_cat_name);
                    $sub_cat_name = $row_sub_cat_name['sub_cat_name'];
    
                    // Initialize array if sub_cat_id not exists
                    if (!isset($data[$sub_cat_id])) {
                        $data[$sub_cat_id] = [
                            "sub_cat_id" => $sub_cat_id,
                            "sub_cat_name" => $sub_cat_name,
                            "items" => []
                        ];
                    }
    
                    // Extract item details
                    $items = [];
                    for ($i = 1; $i <= 40; $i++) {
                        if (!empty($row["item_id_$i"])) {
                            $item_details = json_decode($row["item_details_$i"]);
                            $last_item = end($item_details);
                            $item_id = $last_item->item_id;
    
                            if ($last_item->status != 2) {
                                $query_for_get_item_details = "SELECT item_id, item_name, item_drawing_no, item_part_no 
                                                               FROM item_header_all 
                                                               WHERE item_id = '$item_id'";
                                $result_for_get_item_details = mysqli_query($conn, $query_for_get_item_details);
                                $row_item_details = mysqli_fetch_assoc($result_for_get_item_details);
    
                                $item_details_for_perticuler_item = [
                                    "item_id" => $last_item->item_id,
                                    "item_name" => $row_item_details['item_name'],
                                    "item_drawing_no" => $row_item_details['item_drawing_no'],
                                    "item_part_no" => $row_item_details['item_part_no'],
                                    "working_qty" => $last_item->working_qty,
                                    "rob" => $last_item->rob,
                                    "req_qty" => $last_item->req_qty,
                                    "accepted_qty" => '',
                                    "allocated_qty" => '',
                                    "remark" => $last_item->remark,
                                    "status" => $last_item->status
                                ];
                                
                                $items[] = [
                                    "item_id" => $row["item_id_$i"],
                                    "item_details" => $item_details_for_perticuler_item
                                ];
                            }
                        }
                    }
    
                    // Add items to corresponding sub_cat_id
                    $data[$sub_cat_id]["items"] = array_merge($data[$sub_cat_id]["items"], $items);
                    $data = array_values($data);
                }
            }
    
            $response = [
                'error_code' => 200,
                'data' => $row_req_details,
                'po' => $po_item_details,
                'totalVendors' => count($po_item_details),
                'item_details' => $data
            ];
        } else {
            $response = ['error_code' => 400, 'message' => 'No data found for the given req_id'];
        }
    }
      
    
}
// Return JSON response
echo json_encode($response);
?>
