<?php
session_start();
require_once '../config/config.php';

// Get the database connection
$conn = connection::getConnection();

// Set response header to return JSON
ob_clean();
header('Content-Type: application/json');

// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$token_id = $headers['token_id'] ?? null;
$mode = $headers['mode'] ?? null;

$user_id = $_SESSION['user_id'];
$query_for_get_user_token = "SELECT user_token FROM user_header_all WHERE user_id = '$user_id'";
$result_for_get_user_token = mysqli_query($conn, $query_for_get_user_token);

if ($result_for_get_user_token) {
    $row = mysqli_fetch_assoc($result_for_get_user_token);
    if (!$row || $row['user_token'] !== $_SESSION['user_token']) {
        // Token mismatch - clear session
        session_destroy();
        echo json_encode(['error_code' => 900, 'message' => 'Session expired']);
        exit;
    }
}

// Default response
$response = ['error_code' => 300];

// Check request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Validate required fields for mode 1
    if ($mode == 1) {
        if (!isset($_POST['page']) || !isset($_POST['status'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }

        // Get pagination parameters with default values
        $page = isset($_POST['page']) ? max(1, intval($_POST['page'])) : 1;
        $status = isset($_POST['status']) ? $_POST['status'] : 0;
        $limit = 12;
        $offset = ($page - 1) * $limit;

        // Count total records for pagination
        $query_count = "SELECT COUNT(*) AS total FROM requisition_header_all WHERE req_status = '$status'";
        $result_count = mysqli_query($conn, $query_count);
        $total_records = ($result_count) ? mysqli_fetch_assoc($result_count)['total'] : 0;

        // Fetch requisitions with pagination
        $query_for_get_req = "SELECT r.*, d.dept_no, d.dept_name, u.user_name FROM requisition_header_all AS r LEFT JOIN department_header_all AS d ON r.dept_id = d.dept_id LEFT JOIN user_header_all AS u ON r.user_id = u.user_id WHERE r.req_status = '$status' LIMIT $limit OFFSET $offset";
        $result_for_get_req = mysqli_query($conn, $query_for_get_req);

        if ($result_for_get_req) {
            $requisitions = [];
            while ($row = mysqli_fetch_assoc($result_for_get_req)) {
                $requisitions[] = $row;
            }

            // Prepare response with pagination details
            $response = [
                'error_code' => 200,
                'message' => "Requisitions retrieved successfully",
                'requisitions' => $requisitions,
                'pagination' => [
                    'current_page' => $page,
                    'total_records' => $total_records,
                    'total_pages' => ceil($total_records / $limit),
                    'limit' => $limit,
                    'status' => $status 
                ]
            ];
        } else {
            $response = [
                'error_code' => 400,
                'message' => "Failed to retrieve requisitions"
            ];
        }
    }
    if($mode == 2) {
        if (!isset($_POST['reqNo'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }

        $req_no = mysqli_real_escape_string($conn, trim($_POST['reqNo']));
        $_SESSION['req_no'] = $req_no;

        $response = [
            'error_code' => 200,
            'message' => "session updated"
        ];
    }
}

// Return JSON response
echo json_encode($response);
?>
