<?php
session_start();
require_once '../config/config.php';

// Get the database connection
$conn = connection::getConnection();

// Set response header to return JSON
ob_clean();
header('Content-Type: application/json');

// Retrieve headers
$headers = function_exists('getallheaders') ? getallheaders() : [];
$token_id = $headers['token_id'] ?? null;
$mode = $headers['mode'] ?? null;

$user_id = $_SESSION['user_id'];
$query_for_get_user_token = "SELECT user_token FROM user_header_all WHERE user_id = '$user_id'";
$result_for_get_user_token = mysqli_query($conn, $query_for_get_user_token);

if ($result_for_get_user_token) {
    $row = mysqli_fetch_assoc($result_for_get_user_token);
    if (!$row || $row['user_token'] !== $_SESSION['user_token']) {
        // Token mismatch - clear session
        session_destroy();
        echo json_encode(['error_code' => 900, 'message' => 'Session expired']);
        exit;
    }
}

// Default response
$response = ['error_code' => 300];

// Check request method
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if($mode == 1) {
        if (!isset($_POST['req_no'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $req_no = mysqli_real_escape_string($conn, trim($_POST['req_no']));
        $po_detaoils = [];
        $query_for_get_po = "SELECT p.*, v.ven_name FROM po_vendor_header_all p LEFT JOIN vendor_header_all v ON p.ven_id = v.ven_id  WHERE req_id = (SELECT req_id FROM requisition_header_all WHERE req_no = '$req_no')";
        $result_for_get_po = mysqli_query($conn, $query_for_get_po);

        if ($result_for_get_po) {
            while($row = mysqli_fetch_assoc($result_for_get_po)){
                $po_detaoils[] = $row;
            }

            $response = [
                'error_code' => 200,
                'data' => $po_detaoils
            ];
           
        } else {
            $response = [
                'error_code' => 500,
                'message' => "internal server error"
            ];
        }  
    }
    if($mode == 2) {
        if (!isset($_POST['req_id'], $_POST['po_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $req_id = mysqli_real_escape_string($conn, trim($_POST['req_id']));
        $po_id = mysqli_real_escape_string($conn, trim($_POST['po_id']));
        $po_details_tracker = [];
        $query_for_get_po = "SELECT r.req_date_of_creation, v.ven_name, po.* FROM po_tracker_header_all po LEFT JOIN requisition_header_all r ON po.req_id = r.req_id LEFT JOIN vendor_header_all v ON po.ven_id = v.ven_id WHERE po.req_id = '$req_id' AND po.po_id = '$po_id'";
        $result_for_get_po_tracker = mysqli_query($conn, $query_for_get_po);

        if ($result_for_get_po_tracker) {
            while($row = mysqli_fetch_assoc($result_for_get_po_tracker)){
                $po_details_tracker[] = $row;
            }

            $response = [
                'error_code' => 200,
                'data' => $po_details_tracker
            ];
           
        } else {
            $response = [
                'error_code' => 500,
                'message' => "internal server error"
            ];
        }  
    }
    if($mode == 3) {
        if (!isset($_POST['req_id'], $_POST['po_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $currentDateTime = date('Y-m-d H:i:s');
        $req_id = mysqli_real_escape_string($conn, trim($_POST['req_id']));
        $po_id = mysqli_real_escape_string($conn, trim($_POST['po_id']));
        $po_details_tracker = [];
        $query_for_update_po_status = "UPDATE po_vendor_header_all SET po_status = 5 WHERE req_id = '$req_id' AND po_id = '$po_id'";
        $result_for_update_po_status = mysqli_query($conn, $query_for_update_po_status);

        if ($result_for_update_po_status) {

            $query_for_update_po_tracker_status = "UPDATE po_tracker_header_all SET delivered = '$currentDateTime' WHERE req_id = '$req_id' AND po_id = '$po_id'";
            $result_for_update_po_tracker_status = mysqli_query($conn, $query_for_update_po_tracker_status);

            if($result_for_update_po_tracker_status) {
                $response = [
                    'error_code' => 200,
                    'msg' => 'status uopdated'
                ];
            } else {
                $response = [
                    'error_code' => 500,
                    'message' => "internal server error"
                ];
            }   
        } else {
            $response = [
                'error_code' => 500,
                'message' => "internal server error"
            ];
        }  
    }
     if($mode == 4) {

        // this is for update status of order 
        if (!isset($_POST['req_id'], $_POST['po_id'])) {
            echo json_encode(['error_code' => 300, 'message' => 'Missing required fields']);
            exit;
        }
        $req_id = mysqli_real_escape_string($conn, trim($_POST['req_id']));
        $po_id = mysqli_real_escape_string($conn, trim($_POST['po_id']));
        $po_details_tracker = [];
        $query_for_get_po_items = "SELECT * FROM po_item_details_all  WHERE req_id = '$req_id' AND po_id = '$po_id'";
        $result_for_get_po_items = mysqli_query($conn, $query_for_get_po_items);
        $items = [];

        $query_for_get_vendor = "SELECT po.po_no, v.ven_name FROM po_vendor_header_all po LEFT JOIN vendor_header_all v ON po.ven_id = v.ven_id WHERE po.po_id = '$po_id'";
        $result_for_get_vendor = mysqli_query($conn, $query_for_get_vendor);
        $row_vendor_details = mysqli_fetch_assoc($result_for_get_vendor);


        if ($result_for_get_po_items) {
            while($row = mysqli_fetch_assoc($result_for_get_po_items)){
                for($i= 1; $i<=15; $i++) {
                    if(!empty($row ['poi_item_id_'.$i])){
                        $item_data = $row ['poi_item_id_'.$i];
                        $data_array = json_decode($item_data, true);
                        $item_id = $data_array['item_id'];
    
                        $query_for_get_item_details = "SELECT item_id, item_name, item_drawing_no, item_part_no FROM item_header_all WHERE item_id = '$item_id'";
                        $result_for_get_item_details = mysqli_query($conn, $query_for_get_item_details);
                        $row_item_details = mysqli_fetch_assoc($result_for_get_item_details);
                    
                        // Build item detail JSON for insertion/updation
                        $item_details_for_perticuler_item = [
                            "item_id" => $item_id, 
                            "item_name" => $row_item_details['item_name'], 
                            "item_drawing_no" => $row_item_details['item_drawing_no'], 
                            "item_part_no" => $row_item_details['item_part_no'], 
                            "allocated_qty" => $data_array['allocated_qty']
                        ];
                        $items []= $item_details_for_perticuler_item;
                    } else {
                        break;
                    }
                    
                }
            }

            $response = [
                'error_code' => 200,
                'data' => $items,
                'ven_name' => $row_vendor_details['ven_name'],
                'po_no' => $row_vendor_details['po_no'],
            ];
           
        } else {
            $response = [
                'error_code' => 500,
                'message' => "internal server error"
            ];
        }  
    }
}

// Return JSON response
echo json_encode($response);
?>
