<?php
include_once '../config/config.php';

$req_id = isset($_POST['req_id']) ? $_POST['req_id'] : null;
$action = isset($_POST['action']) ? $_POST['action'] : null;

if (!$req_id) {
    echo json_encode(['error_code' => 400, 'message' => 'req_id is required']);
    exit;
}

try {
    $conn = SqlServerConnection::getConnection();

    if ($action === 'update_delivery') {
        $delivery_date = $_POST['delivery_date'] ?? null;
        $delivery_note = $_POST['delivery_note'] ?? '';
        $delivery_comment = $_POST['delivery_comment'] ?? '';
        $req_status = 4; // Delivered

        if (!$delivery_date) {
            echo json_encode(['error_code' => 400, 'message' => 'Delivery date is required']);
            exit;
        }

        $delivery_file_name = '';

        if (isset($_FILES['delivery_file']) && $_FILES['delivery_file']['error'] === 0) {
            $upload_dir = '../uploads/';
            if (!is_dir($upload_dir)) {
                mkdir($upload_dir, 0777, true);
            }

            // Fetch old file name
            $sql_old = "SELECT delivery_file FROM requisition_header_all WHERE req_id = ?";
            $stmt_old = sqlsrv_query($conn, $sql_old, [$req_id]);
            if ($stmt_old && $row_old = sqlsrv_fetch_array($stmt_old, SQLSRV_FETCH_ASSOC)) {
                $old_file = $row_old['delivery_file'];
                if ($old_file && file_exists($upload_dir . $old_file)) {
                    unlink($upload_dir . $old_file);
                }
            }

            $original_name = basename($_FILES['delivery_file']['name']);
            $clean_name = preg_replace("/[^a-zA-Z0-9.\-_]/", "", $original_name);
            $delivery_file_name = 'Req-' . $req_id . '_' . $clean_name;
            $target_path = $upload_dir . $delivery_file_name;

            if (!move_uploaded_file($_FILES['delivery_file']['tmp_name'], $target_path)) {
                echo json_encode(['error_code' => 500, 'message' => 'File upload failed']);
                exit;
            }
        }

        // Update tracker_header_all
        $sql1 = "UPDATE tracker_header_all 
                 SET delivered = CONVERT(datetime, ?, 120) 
                 WHERE req_id = ?";
        $stmt1 = sqlsrv_query($conn, $sql1, ["$delivery_date " . date('H:i:s'), $req_id]);
        if ($stmt1 === false) {
            echo json_encode(['error_code' => 500, 'message' => 'Failed to update tracker_header_all']);
            exit;
        }

        // Update requisition_header_all
        $sql2 = "UPDATE requisition_header_all 
                 SET delivery_note = ?, 
                     delivery_comment = ?, 
                     req_status = ?" .
                 ($delivery_file_name ? ", delivery_file = ?" : "") .
                 " WHERE req_id = ?";

        $params = [$delivery_note, $delivery_comment, $req_status];
        if ($delivery_file_name) {
            $params[] = $delivery_file_name;
        }
        $params[] = $req_id;

        $stmt2 = sqlsrv_query($conn, $sql2, $params);
        if ($stmt2 === false) {
            echo json_encode(['error_code' => 500, 'message' => 'Failed to update requisition_header_all']);
            exit;
        }

        echo json_encode(['error_code' => 200, 'message' => 'Delivery status updated successfully']);
        exit;
    }

    // Fetch and format tracking data
    $sql = "
        SELECT req_id, requested, cancel_or_reject_datetime,
               order_placed, prepare_for_dispatch, ready_to_ship,
               intransit, delivered
        FROM tracker_header_all
        WHERE req_id = ?
    ";
    $stmt = sqlsrv_query($conn, $sql, [$req_id]);

    if ($stmt === false) {
        echo json_encode(['error_code' => 500, 'message' => 'Database query failed']);
        exit;
    }

    $data = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC);

    if (!$data) {
        echo json_encode(['error_code' => 404, 'message' => 'No tracking data found for this req_id']);
        exit;
    }

    // Function to format date and time
    function formatDate($date) {
        if ($date instanceof DateTime) {
            return $date->format('m/d/Y H:i:s');
        }
        return null;
    }

    $data['requested'] = formatDate($data['requested']);
    $data['cancel_or_reject_datetime'] = formatDate($data['cancel_or_reject_datetime']);
    $data['order_placed'] = formatDate($data['order_placed']);
    $data['prepare_for_dispatch'] = formatDate($data['prepare_for_dispatch']);
    $data['ready_to_ship'] = formatDate($data['ready_to_ship']);
    $data['intransit'] = formatDate($data['intransit']);
    $data['delivered'] = formatDate($data['delivered']);

    echo json_encode([
        'error_code' => 200,
        'message' => 'Success',
        'data' => [$data]
    ]);

} catch (Exception $e) {
    echo json_encode(['error_code' => 500, 'message' => 'Server error: ' . $e->getMessage()]);
}
