// script for fetch tree data
document.addEventListener('DOMContentLoaded', function () {
    document.getElementById('tree').style.display = 'none';
    const treeRoot = document.getElementById('tree');
    const departmentSelect = document.getElementById('departmentSelect');
    
    $.ajax({
        url: './ajax/fetch_tree_data.php',
        type: 'GET',
        dataType: 'json',
        success: function (response) {
            buildTree(response.categories, treeRoot);
            populateDepartments(response.departments, departmentSelect);
        },
        error: function () {
            console.error("Failed to fetch tree data.");
        }
    });
});

// script for radio button type
function handleRequisitionTypeChange(catId = '', itemAdded = '') {
    const radio = document.querySelector('input[name="requisitionType"]:checked')?.value || null;
    const type = document.querySelector('input[name="requisitionType"]:checked')?.value;
    const spareFields = document.getElementById('spareFields');
    const storeFields = document.getElementById('storeFields');
    const treeRoot = document.getElementById('tree');
    const itemTableSection = document.getElementById('itemTableSection');
    const searchContainer = document.getElementById('searchContainer');
    itemTableSection.style.display = 'none';

    const radios = document.querySelectorAll('input[name="requisitionType"]');
    radios.forEach(radio => {
        radio.disabled = true;
    });
 
    if (type === 'Spare') {
        var typeToSend = 1;
        spareFields.style.display = 'flex';
    } else if (type === 'Store') {
        var typeToSend = 2;
        storeFields.style.display = 'flex';
    }
    searchContainer.style.display = type === 'Store' ? 'block' : 'none';
    treeRoot.innerHTML = '';
    treeRoot.style.display = 'block';
    $.ajax({
        url: './ajax/fetch_tree_data.php',
        type: 'GET',
        data:{type: typeToSend},
        dataType: 'json',
        success: function (response) {
            itemTableSection.style.display = 'block';
            if (type === 'Spare') {
                treeRoot.classList.remove('store-mode');
                if(catId != '') {
                    buildTree(response.categories, treeRoot, itemAdded, catId );
                } else {
                    buildTree(response.categories, treeRoot);
                }
            } else {
                treeRoot.classList.add('store-mode'); 
                if(itemAdded != '') {
                    buildFlatItemList(response.flatItems, treeRoot, itemAdded);  
                } else {
                    buildFlatItemList(response.flatItems, treeRoot);
                }
                
            }
        },
        error: function () {
            console.error("Failed to fetch tree data.");
        }
    });
       if(radio == 'Store') {
        const req_eq_name_engine_type = document.getElementById('engineDiv');
        const req_model_type = document.getElementById('modelDiv');
        const req_maker_name = document.getElementById('makerDiv');
        const req_maker_address = document.getElementById('makeraddressDiv');
        const serial_no = document.getElementById('serialNoDiv');
        const departmentDiv = document.getElementById('departmentDiv');
        const priorityDiv = document.getElementById('priorityDiv');
        serial_no.style.display = 'none';
        req_eq_name_engine_type.style.display = 'none';
        req_model_type.style.display = 'none';
        req_maker_name.style.display = 'none';
        req_maker_address.style.display = 'none';
       

        [departmentDiv, priorityDiv].forEach(el => {
            el.classList.remove('col-md-4');
            el.classList.add('col-md-6');
        });
    }
}

// Populate department dropdown
function populateDepartments(departments, dropdown) {
    dropdown.innerHTML = '<option value="" selected disabled>Select Department</option>';
    departments.forEach(dept => {
        const option = document.createElement('option');
        option.value = dept.dept_id;
        option.textContent = dept.dept_name;
        dropdown.appendChild(option);
    });
}

// script for spare tree
function buildFlatItemList(items, parent) {
    const radios = document.querySelector('input[name="requisitionType"]:checked')?.value || null;

    items.forEach(item => {
        const itemLi = document.createElement('li');
        itemLi.textContent = `${item.item_name} (${item.item_part_no})`;
        itemLi.dataset.itemId = item.item_id;
        itemLi.classList.add('item');
        itemLi.style.cursor = 'pointer';

        itemLi.addEventListener('click', () => {
            const isDuplicate = Array.from(document.querySelectorAll('#itemDetailsTable tbody tr'))
                .some(row => row.dataset.itemId === item.item_id.toString());

            if (isDuplicate) {
                alert('This item is already added.');
                return;
            }

            addItemToTable(item, item.item_id, radios);
        });

        parent.appendChild(itemLi);
    });
}


// Collapse all previously expanded nodes
function collapseAllExpandedNodes() {
    const expandedNodes = document.querySelectorAll('#tree .expanded');
    expandedNodes.forEach(node => {
        node.classList.remove('expanded');  
    });
}

// Build the tree with categories, subcategories, and items
const buildTree = (categories, parent, itemAdded = [], catId = '') => {
    categories.forEach(category => {
        const catLi = document.createElement('li');
        catLi.textContent = category.cat_name;
        catLi.classList.add('folder', 'category');
        const subCatUl = document.createElement('ul');
        catLi.dataset.catId = category.cat_id;
        if(catId != '') {
            if (category.cat_id != catId) {
                catLi.classList.add('disabled'); 
                catLi.style.pointerEvents = 'none'; 
                catLi.style.opacity = '0.5';
            }
        }

        if (category.sub_categories?.length) {
            category.sub_categories.forEach(subcat => {
                const subCatLi = document.createElement('li');
                subCatLi.textContent = subcat.sub_cat_name;
                subCatLi.classList.add('folder', 'subcategory');
                const secondSubUl = document.createElement('ul');
                subCatLi.dataset.subCatId = subcat.sub_cat_id;

                if (subcat.second_sub_categories?.length) {
                    subcat.second_sub_categories.forEach(secSub => {
                        const secSubLi = document.createElement('li');
                        secSubLi.textContent = secSub.sec_sub_cat_name;
                        secSubLi.classList.add('folder', 'secondsubcategory');
                        const thirdSubUl = document.createElement('ul');
                        secSubLi.dataset.secSubCatId = secSub.sec_sub_cat_id;

                        if (secSub.third_sub_categories?.length) {
                            secSub.third_sub_categories.forEach(thirdSub => {
                                const thirdSubLi = document.createElement('li');
                                thirdSubLi.textContent = thirdSub.third_sub_cat_name;
                                thirdSubLi.classList.add('folder', 'thirdsubcategory');
                                const itemUl = document.createElement('ul');
                                thirdSubLi.dataset.thirdSubCatId = thirdSub.third_sub_cat_id;

                                const radios = document.querySelector('input[name="requisitionType"]:checked')?.value || null;

                                if (thirdSub.items?.length) {
                                    thirdSub.items.forEach(item => {
                                        const itemLi = document.createElement('li');
                                        itemLi.textContent = `${item.item_name} (${item.item_part_no})`;
                                        itemLi.classList.add('item');
                                        itemLi.style.cursor = 'pointer';

                                        // Data attributes
                                        itemLi.dataset.itemId = item.item_id;
                                        itemLi.dataset.catId = catLi.dataset.catId;
                                        itemLi.dataset.subCatId = subCatLi.dataset.subCatId;
                                        itemLi.dataset.secSubCatId = secSubLi.dataset.secSubCatId;
                                        itemLi.dataset.thirdSubCatId = thirdSubLi.dataset.thirdSubCatId;

                                        itemLi.addEventListener('click', (event) => {
                                            event.stopPropagation();
                                            addItemToTable(item,
                                                itemLi.dataset.itemId,
                                                radios,
                                                itemLi.dataset.catId,
                                                itemLi.dataset.subCatId,
                                                itemLi.dataset.secSubCatId,
                                                itemLi.dataset.thirdSubCatId,
                                                itemAdded
                                            );
                                        });

                                        itemUl.appendChild(itemLi);
                                    });
                                } else {
                                    const noItemLi = document.createElement('li');
                                    noItemLi.textContent = 'No data found for this';
                                    noItemLi.classList.add('no-data');
                                    itemUl.appendChild(noItemLi);
                                }

                                thirdSubLi.appendChild(itemUl);
                                thirdSubUl.appendChild(thirdSubLi);
                                addToggleIfHasChildren(thirdSubLi);
                            });
                        } else {
                            const noThirdSubLi = document.createElement('li');
                            noThirdSubLi.textContent = 'No data found for this';
                            noThirdSubLi.classList.add('no-data');
                            thirdSubUl.appendChild(noThirdSubLi);
                        }

                        secSubLi.appendChild(thirdSubUl);
                        secondSubUl.appendChild(secSubLi);
                        addToggleIfHasChildren(secSubLi);
                    });
                } else {
                    const noSecSubLi = document.createElement('li');
                    noSecSubLi.textContent = 'No data found for this';
                    noSecSubLi.classList.add('no-data');
                    secondSubUl.appendChild(noSecSubLi);
                }

                subCatLi.appendChild(secondSubUl);
                subCatUl.appendChild(subCatLi);
                addToggleIfHasChildren(subCatLi);
            });
        } else {
            const noSubCatLi = document.createElement('li');
            noSubCatLi.textContent = 'No data found for this';
            noSubCatLi.classList.add('no-data');
            subCatUl.appendChild(noSubCatLi);
        }

        catLi.appendChild(subCatUl);
        addToggleIfHasChildren(catLi);

        catLi.addEventListener('click', function (e) {
            e.stopPropagation();
            collapseAllExpandedNodes();
            this.classList.add('expanded');

            const requisitionType = document.querySelector('input[name="requisitionType"]:checked')?.value;

            if (requisitionType === 'Spare') {
                document.getElementById('engineDropdown').value = category.cat_name;
            }

            if (category.cat_name === 'Store') {
                document.querySelectorAll('.category, .subcategory, .secondsubcategory, .thirdsubcategory, .item').forEach(el => {
                    el.style.display = 'none';
                });
                document.getElementById('flatItemContainer').style.display = 'block';
            } else {
                document.querySelectorAll('.category, .subcategory, .secondsubcategory, .thirdsubcategory, .item').forEach(el => {
                    el.style.display = '';
                });
                document.getElementById('flatItemContainer').style.display = 'none';
            }
        });

        parent.appendChild(catLi);
    });
};

// Add toggle logic
function addToggleIfHasChildren(liElement) {
    const hasChildList = liElement.querySelector('ul');
    if (hasChildList) {
        liElement.classList.add('has-children');
        liElement.addEventListener('click', function (e) {
            e.stopPropagation();
            this.classList.toggle('expanded');
        });
    }
}

// Search functionality
function debounce(func, delay) {
    let timeout;
    return function (...args) {
        clearTimeout(timeout);
        timeout = setTimeout(() => func.apply(this, args), delay);
    };
}

// Debounced wrapper
const debouncedSearchTree = debounce(function (query) {
    searchTree(query);
});

function searchTree(query) {
    const items = Array.from(document.querySelectorAll('#tree li'));
    query = query.trim().toLowerCase();

    if (!query) {
        items.forEach(li => li.style.display = '');
        return;
    }

    const processChunk = (startIndex = 0, chunkSize = 1000) => {
        const endIndex = Math.min(startIndex + chunkSize, items.length);

        for (let i = startIndex; i < endIndex; i++) {
            const li = items[i];
            const text = li.textContent.toLowerCase();
            if (text.includes(query)) {
                li.style.display = '';
                showParents(li);
            } else {
                li.style.display = 'none';
            }
        }

        if (endIndex < items.length) {
            requestIdleCallback 
                ? requestIdleCallback(() => processChunk(endIndex)) 
                : setTimeout(() => processChunk(endIndex), 0);
        }
    };

    processChunk();
}

function showParents(el) {
    let parent = el.parentElement;
    while (parent && parent.id !== 'tree') {
        if (parent.tagName === 'UL') parent.style.display = 'block';
        if (parent.tagName === 'LI') {
            parent.classList.add('expanded');
            parent.style.display = '';
        }
        parent = parent.parentElement;
    }
}

// Add item to table
function addItemToTable(item, item_id, radios, cat_id = 0, sub_cat_id = 0, sec_sub_cat_id = 0, third_sub_cat_id = 0, itemAdded = []) {
    const tbody = document.querySelector('#itemDetailsTable tbody');
    const thead = document.querySelector('#itemDetailsTable thead');

    const isDuplicate = Array.from(tbody.querySelectorAll('tr')).some(row => row.dataset.itemId === item_id);
    const isDuplicateInArray = itemAdded.includes(Number(item_id));
    if (isDuplicate) {
        alert('This item is already added.');
        return;
    } else if (isDuplicateInArray) {
        alert('This item is already added.');
        return;
    }

    const newSrNo = tbody.querySelectorAll('tr').length + 1;

    const row = document.createElement('tr');
    row.innerHTML = `
        <td style="text-align: center;">${newSrNo}</td>
        <td style="text-align: center;">${item.item_name}</td>
        <td class="drawingNo" style="text-align: center;">${item.item_part_no}</td>
        <td style="text-align: center;">Loading...</td>
        <td class="workingQty" style="text-align: center;"><input type="number" class="form-control" name="working_qty[]" style="height: 2px;"></td>
        <td style="text-align: center;"><input type="number" class="form-control" name="rob[]" style="height: 2px;"></td>
        <td style="text-align: center;"><input type="number"id="req_qty" class="form-control req_qty" name="req_qty[]" style="height: 2px;"></td>
        <td class="unitField" style="text-align: center;"><input type="text" class="form-control" value="${item.uom}" name="units[]" style="height: 2px;"></td>
        <td style="text-align: center;"><input type="text" class="form-control" name="remarks[]" style="height: 2px;"></td>
        <td style="text-align: center;">
            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)"><i class="fa fa-times"></i></button>
        </td>
    `;

    row.dataset.itemId = item_id;
    row.dataset.catId = cat_id;
    row.dataset.subCatId = sub_cat_id;
    row.dataset.secSubCatId = sec_sub_cat_id;
    row.dataset.thirdSubCatId = third_sub_cat_id;

    tbody.appendChild(row);

    // Hide/show columns
    if (radios === 'Spare') {
        row.querySelectorAll('.unitField').forEach(el => el.style.display = 'none');
        thead.querySelectorAll('th')[7].style.display = 'none';
    } else {
        row.querySelectorAll('.drawingNo, .workingQty').forEach(el => el.style.display = 'none');
        thead.querySelectorAll('th')[2].style.display = 'none';
        thead.querySelectorAll('th')[4].style.display = 'none';
    }

    // Disable other categories
    document.querySelectorAll('.category').forEach(catEl => {
        if (catEl.dataset.catId !== cat_id) {
            catEl.classList.add('disabled-category');
            catEl.style.pointerEvents = 'none';
            catEl.style.opacity = 0.5;
        }
    });

    // Fetch part number/drawing no
    $.ajax({
        url: `./ajax/fetch_tree_data.php?item_id=${encodeURIComponent(item.item_id)}`,
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            row.children[2].textContent = data.item_drawing_no || 'N/A';
            row.children[3].textContent = data.item_part_no || 'N/A';
        },
        error: function () {
            row.children[2].textContent = 'N/A';
            row.children[3].textContent = 'N/A';
        }
    });
}

// script for remove item from list 
function removeRow(btn, reqId = '', itemId = '') {
    const row = btn.closest('tr');
    row.remove();
    updateSerialNumbers();

    const rows = document.querySelectorAll('#itemDetailsTable tbody tr');
    if (rows.length === 0) {
        document.querySelectorAll('.category').forEach(catEl => {
            catEl.classList.remove('disabled-category');
            catEl.style.pointerEvents = '';
            catEl.style.opacity = '';
        });
    }

    if(itemId != '') {
        $.ajax({
        url: './ajax/json_for_remove_item_from_req.php',
        type: 'POST',
        data: { 
            reqId: reqId, 
            itemId: itemId 
        },
        dataType: 'json',
        success: function (response) {
            location.reload();
        },
        error: function () {
            console.error("Failed to fetch tree data.");
        }
    });
    }

}

// Update serial numbers
function updateSerialNumbers() {
    const rows = document.querySelectorAll('#itemDetailsTable tbody tr');
    rows.forEach((row, index) => {
        row.querySelector('td').textContent = index + 1;
    });
}

// script to stroe item data 
function storeRowData(btn) {
    const row = btn.closest('tr');
    const workingQty = row.querySelector('[name="working_qty[]"]').value;
    const rob = row.querySelector('[name="rob[]"]').value;
    const reqQty = row.querySelector('[name="req_qty[]"]').value;
    const units = row.querySelector('[name="units[]"]').value;
    const remarks = row.querySelector('[name="remarks[]"]').value;

    const itemId = row.dataset.itemId;
    const catId = row.dataset.catId;
    const subCatId = row.dataset.subCatId;
    const secSubCatId = row.dataset.secSubCatId;
    const thirdSubCatId = row.dataset.thirdSubCatId;

    const rowData = {
        itemId: itemId,
        catId: catId,
        subCatId: subCatId,
        secSubCatId:secSubCatId,
        thirdSubCatId:thirdSubCatId,
        item_name: row.children[1].textContent,
        working_qty: workingQty,
        rob: rob,
        req_qty: reqQty,
        units: units,
        remarks: remarks
    };
    console.log(rowData);
}

function showConfirmSubmission() {
  document.getElementById('confirmSubmission').style.display = '';
}

function closeConfirmSubmission() {
  document.getElementById('confirmSubmission').style.display = 'none';
}

function showSubmissionSuccess() {
  document.getElementById('submissionSuccess').style.display = '';
  window.location.href = './index.php';
}

// Script for validate required fields
function validateAndConfirmSubmission() {
  const req_no = document.getElementById('requisitionNumber')?.value.trim();
  const  req_qty= document.getElementById ('req_qty')?.value.trim();
  const  departmentSelect= document.getElementById ('departmentSelect')?.value.trim();
  const req_for = document.querySelector(`input[name="requisitionType"]:checked`)?.value;
  const rows = document.querySelectorAll('#itemDetailsTable tbody tr');

  if (!req_no || !req_for || !departmentSelect) {
    alert("Please enter required feilds.");
    return;
  }

  let isValid = true;

    $('.req_qty').each(function() {
        if ($(this).val() === '') {
            isValid = false;
            return false;
        }
    });

    if (!isValid) {
        alert('Please fill all "Required Quantity" fields.');
        return;
    }




  if (rows.length === 0) {
    alert("Please add at least one item to the requisition.");
    return;
  }

  showConfirmSubmission();
}

document.getElementById('finalSubmitBtn').addEventListener('click', function () {
  closeConfirmSubmission(); 
  performFinalSubmission(); 
});


// script for data submission
function performFinalSubmission() {
  const getValue = id => document.getElementById(id)?.value.trim();
  const getRadioValue = name => document.querySelector(`input[name="${name}"]:checked`)?.value;

  const req_no = getValue('requisitionNumber');
  const dept_id = getValue('departmentSelect');
  const req_serial_no = getValue('serialNo');
  const req_for = getRadioValue('requisitionType');
  const req_priority = getValue('priority');
  const req_eq_name_engine_type = getValue('engineDropdown');
  const req_model_type = getValue('modelType');
  const req_maker_name = getValue('makerName');
  const req_maker_address = getValue('makerAddress');
  const req_remark = getValue('remark');

  const cat_id = window.selectedCatId || null;
  const sub_cat_id = window.selectedSubCatId || null;
  const sec_sub_cat_id = window.selectedSecSubCatId || null;
  const third_sub_cat_id = window.selectedThirdSubCatId || null;

  const rows = document.querySelectorAll('#itemDetailsTable tbody tr');

  const items = Array.from(rows).map(row => ({
    item_id: row.dataset.itemId,
    item_name: row.children[1].textContent.trim(),
    drawing_no: row.children[2].textContent.trim(),
    part_no: row.children[3].textContent.trim(),
    working_qty: row.querySelector('[name="working_qty[]"]').value.trim(),
    rob: row.querySelector('[name="rob[]"]').value.trim(),
    req_qty: row.querySelector('[name="req_qty[]"]').value.trim(),
    unit: row.querySelector('[name="units[]"]').value.trim(),
    remark: row.querySelector('[name="remarks[]"]').value.trim(),
    cat_id: row.dataset.catId,
    sub_cat_id: row.dataset.subCatId,
    sec_sub_cat_id: row.dataset.secSubCatId,
    third_sub_cat_id: row.dataset.thirdSubCatId
  }));

  const data = {
    req_no,
    dept_id,
    req_serial_no,
    req_for,
    req_priority,
    req_eq_name_engine_type,
    req_model_type,
    req_maker_name,
    req_maker_address,
    req_remark,
    cat_id,
    sub_cat_id,
    sec_sub_cat_id,
    third_sub_cat_id,
    items
  };

  $.ajax({
    url: './ajax/submit_requisition.php',
    type: 'POST',
    contentType: 'application/json',
    data: JSON.stringify(data),
    dataType: 'json',
    success: function (response) {
      if (response.error_code === 200) {
        showSubmissionSuccess();
      } else {
        alert('Error: ' + response.message);
        console.error('Server Response:', response);
      }
    },
    error: function (xhr, status, error) {
      alert('An unexpected error occurred.');
      console.error('AJAX Error:', error);
    }
  });
}

// script for change requisition number as per the department selection
function handleDepartmentChange() {
    var departmentId = document.getElementById('departmentSelect').value;
    if (departmentId) {
        var formData = { dept_id: departmentId };
        
        $.ajax({
            url: "./ajax/json_for_requisition_no_v1_0.php",
            type: "POST",
            data: formData,
            dataType: "json",
            contentType: "application/x-www-form-urlencoded",
            headers: {
                "mode": "1"
            },
            success: function (response) {
                if (response.error_code === 200) {
                    document.getElementById('requisitionNumber').value = response.req_no;
                } else {
                    console.error('Server Response:', response);
                }
            },
            error: function (xhr, status, error) {
                console.error('AJAX Error:', error);
            }
        });
    } else {
        console.log('No department selected');
    }
}

// script for draft field validations
function validateAndConfirmDraft() {
    const req_no = document.getElementById('requisitionNumber')?.value.trim();
    const req_qty = document.getElementById('req_qty')?.value.trim();
    const departmentSelect = document.getElementById('departmentSelect')?.value.trim();
    const req_for = document.querySelector(`input[name="requisitionType"]:checked`)?.value;
    const rows = document.querySelectorAll('#itemDetailsTable tbody tr');

    if (!req_no || !req_for || !departmentSelect) {
        alert("Please enter required fields.");
        return;
    }

    let isValid = true;

    $('.req_qty').each(function() {
        if ($(this).val() === '') {
            isValid = false;
            return false;
        }
    });

    if (!isValid) {
        alert('Please fill all "Required Quantity" fields.');
        return;
    }

    if (rows.length === 0) {
        alert("Please add at least one item to the requisition.");
        return;
    }
    showConfirmDraft();
}

function showConfirmDraft() {
    document.getElementById('confirmDraft').style.display = ''; 
}

function closeConfirmSubmission(modalId) {
    document.getElementById(modalId).style.display = 'none';
}

function performSaveAsDraft() {
    console.log("Saving as draft...");
    closeConfirmSubmission('confirmDraft');
    saveDraft();
    window.location.href = './draft_requisition.php';
    // alert('Requisition saved as draft. You can continue it later from the Draft Requisitions section.');
}


// script to save draft data 
function saveDraft() {
    const getValue = id => document.getElementById(id)?.value.trim();
    const getRadioValue = name => document.querySelector(`input[name="${name}"]:checked`)?.value;

    const req_no = getValue('requisitionNumber');
    const dept_id = getValue('departmentSelect');
    const req_serial_no = getValue('serialNo');
    const req_for = getRadioValue('requisitionType');
    const req_priority = getValue('priority');
    const req_eq_name_engine_type = getValue('engineDropdown');
    const req_model_type = getValue('modelType');
    const req_maker_name = getValue('makerName');
    const req_maker_address = getValue('makerAddress');
    const req_remark = getValue('remark');

    const cat_id = window.selectedCatId || null;
    const sub_cat_id = window.selectedSubCatId || null;
    const sec_sub_cat_id = window.selectedSecSubCatId || null;
    const third_sub_cat_id = window.selectedThirdSubCatId || null;

    const rows = document.querySelectorAll('#itemDetailsTable tbody tr');

    const items = Array.from(rows).map(row => ({
        item_id: row.dataset.itemId,
        item_name: row.children[1].textContent.trim(),
        drawing_no: row.children[2].textContent.trim(),
        part_no: row.children[3].textContent.trim(),
        working_qty: row.querySelector('[name="working_qty[]"]').value.trim(),
        rob: row.querySelector('[name="rob[]"]').value.trim(),
        req_qty: row.querySelector('[name="req_qty[]"]').value.trim(),
        unit: row.querySelector('[name="units[]"]').value.trim(),
        remark: row.querySelector('[name="remarks[]"]').value.trim(),
        cat_id: row.dataset.catId,
        sub_cat_id: row.dataset.subCatId,
        sec_sub_cat_id: row.dataset.secSubCatId,
        third_sub_cat_id: row.dataset.thirdSubCatId
    }));

    const payload = {
        req_status: 0, 
        req_no,
        dept_id,
        req_serial_no,
        req_for,
        req_priority,
        req_eq_name_engine_type,
        req_model_type,
        req_maker_name,
        req_maker_address,
        req_remark,
        cat_id,
        sub_cat_id,
        sec_sub_cat_id,
        third_sub_cat_id,
        items
    };

    $.ajax({
        url: './ajax/save_as_draft.php',
        method: 'POST',
        contentType: 'application/json',
        data: JSON.stringify(payload),
        dataType: 'json',
        success: function (res) {
            if (res.error_code === 200) {
            } else {
                alert("Error saving draft: " + res.message);
                console.error(res);
            }
        },
        error: function (xhr, status, error) {
            alert("AJAX error occurred while saving draft.");
            console.error(xhr.responseText);
        }
    });
}



// script to load draft requuisition data 
function loadDraftRequisition(req_id) {
    $.ajax({
        url: './ajax/fetch_draft_requisition.php',
        method: 'POST',
        contentType: 'application/json',
        data: JSON.stringify({ req_id: req_id }),
        success: function (response) {
            if (response.error_code === 200) {
                console.log(response)
                const header = response.header;
                const items = response.items;
                const catId = response.cat_id;
                const itemAdded = response.item_id_array;

                // Populate header fields
                $('#requisitionNumber').val(header.req_no);
                $('#remark').val(header.req_remark);
                $('#engineDropdown').val(header.req_eq_name_engine_type);
                $('#modelType').val(header.req_model_type);
                $('#makerName').val(header.req_maker_name);
                $('#serialNo').val(header.req_serial_no);
                $('#priority').val(header.req_priority);
                $('#modelMakerId').val(header.req_maker_address);
                $('#departmentSelect').val(header.dept_id);

                let isSpare = false;
                if (header.req_for === '1') {
                    isSpare = true;
                    document.getElementById('spare').checked = true;
                    handleRequisitionTypeChange(catId, itemAdded);
                    
                    $('#spare').prop('checked', true);
                    $('#engineDiv, #modelDiv, #makerDiv, #serialNoDiv').show();
                    $('#departmentDiv, #priorityDiv').removeClass('col-md-4').addClass('col-md-6');
                } else if (header.req_for === '2') {
                    document.getElementById('store').checked = true;
                    handleRequisitionTypeChange(itemAdded);
                    $('#store').prop('checked', true);
                    $('#engineDiv, #modelDiv, #makerDiv, #serialNoDiv').hide();
                    $('#departmentDiv, #priorityDiv').removeClass('col-md-4').addClass('col-md-6');
                }

                $('#itemTableSection').show();
                const tbody = $('#itemDetailsTable tbody');
                const thead = $('#itemDetailsTable thead');
                tbody.empty();

                thead.find('th').eq(2).show(); // Drawing No.
                thead.find('th').eq(4).show(); // Working Qty
                thead.find('th').eq(7).show(); // Units

                items.forEach((item, index) => {
                    const newSrNo = index + 1;
                    const row = document.createElement('tr');

                    row.innerHTML = `
                        <td style="text-align: center;">${newSrNo}</td>
                        <td style="text-align: center;">${item.item_name || ''}</td>
                        <td class="drawingNo" style="text-align: center;">${item.drawing_no || ''}</td>
                        <td style="text-align: center;">${item.part_no || ''}</td>
                        <td class="workingQty" style="text-align: center;">
                            <input type="number" class="form-control" name="working_qty[]" value="${item.working_qty || ''}" style="height: 2px;">
                        </td>
                        <td style="text-align: center;">
                            <input type="number" class="form-control" name="rob[]" value="${item.rob || ''}" style="height: 2px;">
                        </td>
                        <td style="text-align: center;">
                            <input type="number" class="form-control" name="req_qty[]" value="${item.req_qty || ''}" style="height: 2px;">
                        </td>
                        <td class="unitField" style="text-align: center;">
                            <input type="text" class="form-control" name="units[]" value="${item.unit || ''}" style="height: 2px;">
                        </td>
                        <td style="text-align: center;">
                            <input type="text" class="form-control" name="remarks[]" value="${item.remark || ''}" style="height: 2px;">
                        </td>
                        <td style="text-align: center;">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this, ${req_id}, ${item.item_id})">
                                <i class="fa fa-times"></i>
                            </button>
                        </td>
                    `;

                    // Conditionally hide columns
                    if (isSpare) {
                        row.querySelectorAll('.unitField').forEach(el => el.style.display = 'none');
                        thead.find('th').eq(7).hide(); 
                    } else {
                        row.querySelectorAll('.drawingNo, .workingQty').forEach(el => el.style.display = 'none');
                        thead.find('th').eq(2).hide(); 
                        thead.find('th').eq(4).hide(); 
                    }

                    tbody.append(row);
                });

            } else {
                alert("Error fetching draft: " + response.message);
            }
        },
        error: function (xhr, status, error) {
            console.error('AJAX error:', error);
            alert("Failed to fetch requisition details.");
        }
    });
}


