<?php

session_start();
require_once './config/config.php';

  if (!isset($_SESSION['user_id']) && !isset ($_GET['user_name'])) {
    header("Location: ./login.php");
    exit; // Important to stop further execution
}


$conn = SqlServerConnection::getConnection();

if (isset($_GET['user_name']) && isset($_GET['type']) && isset($_GET['ship_id']) && isset($_GET['user_email'])) {
    $user_name = $_GET['user_name'];
    $user_type = $_GET['type'];
    $ship_id = $_GET['ship_id'];
    $user_email = $_GET['user_email'];

    $query = "SELECT ship_name FROM ship_header_all WHERE ship_id = ?";
    $stmt = sqlsrv_query($conn, $query, [$ship_id]);

    if ($stmt && ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC))) {
        $_SESSION['user_id'] = '';
        $_SESSION['ship_id'] = $ship_id;
        $_SESSION['user_no'] = ''; 
        $_SESSION['user_name'] = $user_name;
        $_SESSION['user_email'] = $user_email;
        $_SESSION['user_type'] = $user_type;
        $_SESSION['ship_name'] = $row['ship_name'];
        $_SESSION['profile_name'] = 'Ship Captain';
        $_SESSION['user_initials'] = getInitials($user_name);
    }
}

$Ship_id_for_function = isset($_SESSION['ship_id']) ? $_SESSION['ship_id'] : (isset($_GET['ship_id']) ? $_GET['ship_id'] : null);
$user_token_for_function = isset($_SESSION['user_token']) ? $_SESSION['user_token'] : '';

include 'includes/header.php';

function getInitials($fullName) {
    $nameParts = explode(" ", trim($fullName));
    if (count($nameParts) == 1) {
        return strtoupper(substr($nameParts[0], 0, 1));
    } else {
        return strtoupper(substr($nameParts[0], 0, 1) . substr(end($nameParts), 0, 1));
    }
}
?>



<script>

  window.onload = function() {
    getAllRequisitionHeaderWithStatus('<?php echo $Ship_id_for_function ?>', '<?php echo $user_token_for_function ?>');
   
};

</script>