<?php
session_start();
include './includes/header.php';
?>

<link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">  

<div class="container-scroller">
    <?php include './includes/profilebasenavbar.php'; ?>
    <div class="container-fluid page-body-wrapper">
        <?php include './includes/sidebarmenu.php'; ?>
        <div class="main-panel">
            <div class="content-wrapper">
                <div class="row">   
                    <div class="col-sm-12">
                        <div class="home-tab">
                            <div class="tab-content tab-content-basic" style="padding: 0;">
                                <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">
                                    <div class="container form-container">
                                        <div class="container mt-2">
                                            <h4 class="mb-1">Create New User</h4>

                                            <div class="card">
                                                <form id="addUserForm" action="add_user.php" method="POST">
                                                    <div class="form-group text-center row justify-content-center">
                                                        <div class="col-md-4">
                                                            <label for="name"><strong>Name</strong></label>
                                                            <input type="text" id="name" name="name" class="form-control" placeholder="Enter Name" required>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label for="email"><strong>Email</strong></label>
                                                            <input type="email" id="email" name="email" class="form-control" placeholder="Enter Email" required>
                                                        </div>
                                                        <div class="col-md-4">
                                                            <label for="mobile"><strong>Mobile Number</strong></label>
                                                            <input type="text" id="mobile" name="mobile" class="form-control" placeholder="Enter Mobile Number" required>
                                                        </div>
                                                    </div>

                                                    <div class="form-group text-center row justify-content-center">
                                                        <div class="col-md-3">
                                                            <label for="user_type"><strong>Type</strong></label>
                                                            <select id="user_type" name="user_type" class="form-control" required>
                                                                <option value="" disabled selected>Select Type</option>
                                                                <option value="1">Land</option>
                                                                <option value="2">Ship</option>
                                                            </select>

                                                        </div>
                                                        <div class="col-md-3">
                                                            <label for="profile"><strong>Profile</strong></label>
                                                            <select id="profile" name="profile" class="form-control" required>
                                                                <!-- Profile options will be dynamically loaded here -->
                                                            </select>
                                                        </div>

                                                        <div class="col-md-3">
                                                            <label for="username"><strong>User Name</strong></label>
                                                            <input type="text" id="username" name="username" class="form-control" placeholder="Enter Username" required>
                                                        </div>
                                                        <div class="col-md-3">
                                                            <label for="password"><strong>Password</strong></label>
                                                            <input type="password" id="password" name="password" class="form-control" placeholder="Enter Password" required>
                                                        </div>

                                                    </div>

                                                    <button type="submit" class="btn btn-outline-primary mx-auto d-block">Create User</button>
                                                </form>

                                                <div class="mt-1" style="display: flex; justify-content: flex-end;">
                                                    <input type="text" id="searchUser" class="form-control" placeholder="Search user" style="max-width: 17%; height: 30px;">
                                                </div>

                                                <div id="usersTable" class="mt-4">
                                                    <table class="table datatable">
                                                        <thead>
                                                            <tr>
                                                                <!-- <th>User No</th> -->
                                                                <th>Name</th>
                                                                <th>Email</th>
                                                                <th>Mobile</th>
                                                                <th>Type</th>
                                                                <th>Profile</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody id="usersList">
                                                            <!-- Users will be loaded here -->
                                                        </tbody>
                                                    </table>
                                                </div>

                                                <div id="pagination-links" class="pagination justify-content-center">
                                                    <!-- Pagination buttons will be injected here -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php include './includes/footer.php'; ?>
        </div>
    </div>
</div>

<?php include './includes/dependancy.php'; ?>
<script src="assets/js/addUser.js"></script>
