<?php 

/*
Objective: This API handles department, category, equipment, and maker details retrieval based on different request modes.
File Version: 1.0
API NO: SBK02
Date of Creation: 25/03/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone:

Date: 25/03/2025

Request Method:
Type: POST

Headers:
Content-Type: application/json

Request Parameters:
The API expects the following parameters in the request body:

mode (integer, required) - Defines the action to be performed:
    * 1: Fetch all departments
    * 2: Fetch categories or equipment based on department ID
    * 3: Fetch equipment or maker details based on category ID
    * 4: Fetch maker details based on equipment ID

department_id (integer, optional) - Required when mode = 2.
category_id (integer, optional) - Required when mode = 3.
equipment_id (integer, optional) - Required when mode = 4.

If any required parameter is missing, the API returns an error response.

***********

Process Flow:

*Step 1: Input Validation
- The system checks if the required parameters are provided for the selected mode.
- If any field is missing, an error response "Missing required fields" is returned with error_code 400.

*Step 2: Fetch Department Details (mode = 1)
- Retrieves all departments from the `department_header_all` table.
- If records are found, it returns error_code 200 with department details.
- If no records are found, error_code 500 is returned.

*Step 3: Fetch Category or Equipment Details (mode = 2)
- Checks if `dept_id` is provided.
- Retrieves category details from `category_header_all` based on department ID.
- If no categories are found, it retrieves equipment details from `equipment_header_all`.
- Response includes error_code 200 and data_from: 'cat' or 'eq'.

*Step 4: Fetch Equipment or Maker Details (mode = 3)
- Checks if `cat_id` is provided.
- Retrieves equipment details from `equipment_header_all`.
- If no equipment is found, retrieves maker details from `modal_maker_header_all`.
- If a single maker record is found, response includes error_code 200 and data_from: 'mk'.

*Step 5: Fetch Maker Details (mode = 4)
- Checks if `eq_id` is provided.
- Retrieves maker details from `modal_maker_header_all` based on equipment ID.
- If a single record is found, response includes error_code 200 and data_from: 'mk'.

********

Response Structure:

*Success Responses:
If data is retrieved successfully, the API returns:

error_code: 200 (indicating success).
data: The requested details (departments, categories, equipment, or makers).
data_from: Identifies the source of data ('cat', 'eq', or 'mk').

*Failure Responses:
If required fields are missing, the response contains:

error_code: 400
message: "Missing required fields"

If no records are found, the response contains:

error_code: 500
message: "No records found"

If the request method is not POST, the response contains:

error_code: 300
message: "Invalid request method"

-------------------------------------------------------------------------------------------------------------------------------

Date:

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone:

Date:

*/

session_start();
require_once '../config/config.php';

// Get the database connection
$conn = connection::getConnection(); // Assuming your class name is Database

// Set response header to return JSON
header('Content-Type: application/json');

// Default response for invalid request
$response = ['error_code' => 300];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Check if required fields exist
    if (!isset($_POST['mode'])) {
        echo json_encode(['error_code' => 400, 'message' => 'Missing required fields']);
        exit;
    }
     
    // Sanitize user inputs 
    $mode = mysqli_real_escape_string($conn, trim($_POST['mode']));

    // Fetch department details
    if($mode == 1) {
        $query_for_department = "SELECT dept_id, dept_name FROM department_header_all";
        $result_for_department = $conn->query($query_for_department);
        $dept_details = [];
        
        if ($result_for_department && mysqli_num_rows($result_for_department) > 0) {
            while ($row_dept_details = mysqli_fetch_assoc($result_for_department)) {
                $dept_details[] = $row_dept_details; 
            }
            $response = [
                'error_code' => 200,
                'data' => $dept_details,
            ];
        } else {
            $response = [
                'error_code' => 500
            ];
        }
    } 
    
    // Fetch category or equipment based on department ID
    else if($mode == 2) {
        if (!isset($_POST['dept_id'])) {
            echo json_encode(['error_code' => 400, 'message' => 'Missing required fields']);
            exit;
        }
        
        $dept_id = $_POST['dept_id'];
        $query_for_get_category = "SELECT cat_id, cat_name FROM category_header_all WHERE dept_id = '$dept_id'";
        $result_for_get_category = $conn->query($query_for_get_category);
        $cat_details = [];
        
        if ($result_for_get_category && mysqli_num_rows($result_for_get_category) > 0) {
            while ($row_cat_details = mysqli_fetch_assoc($result_for_get_category)) {
                $cat_details[] = $row_cat_details; 
            }
            $response = [
                'error_code' => 200,
                'data' => $cat_details,
                'data_from' => 'cat'
            ];
        } else {
            // If no categories, fetch equipment details
            $query_for_get_equipment = "SELECT eq_id, eq_name FROM equipment_header_all WHERE dept_id = '$dept_id'";
            $result_for_get_equipment = $conn->query($query_for_get_equipment);
            $eq_details = [];
            
            if ($result_for_get_equipment && mysqli_num_rows($result_for_get_equipment) > 0) {
                while ($row_eq_details = mysqli_fetch_assoc($result_for_get_equipment)) {
                    $eq_details[] = $row_eq_details; 
                }
                $response = [
                    'error_code' => 200,
                    'data' => $eq_details,
                    'data_from' => 'eq'
                ];
            } else {
                $response = [
                    'error_code' => 500
                ];
            }
        }
    } 
    
    // Fetch equipment details based on category ID
    else if($mode == 3) {
        if (!isset($_POST['cat_id'])) {
            echo json_encode(['error_code' => 400, 'message' => 'Missing required fields']);
            exit;
        }
        
        $cat_id = $_POST['cat_id'];
        $query_for_get_equipment = "SELECT eq_id, eq_name FROM equipment_header_all WHERE cat_id = '$cat_id'";
        $result_for_get_equipment = $conn->query($query_for_get_equipment);
        $eq_details = [];
        
        if ($result_for_get_equipment && mysqli_num_rows($result_for_get_equipment) > 0) {
            while ($row_eq_details = mysqli_fetch_assoc($result_for_get_equipment)) {
                $eq_details[] = $row_eq_details; 
            }
            $response = [
                'error_code' => 200,
                'data' => $eq_details,
                'data_from' => 'eq'
            ];
        } else {
            // If no equipment found, fetch maker details
            $query_for_get_maker = "SELECT m_id, model_name, maker_name, maker_address FROM modal_maker_header_all WHERE cat_id = '$cat_id'";
            $result_for_get_maker = $conn->query($query_for_get_maker);
            
            if ($result_for_get_maker && mysqli_num_rows($result_for_get_maker) == 1) {
                $maker_details = mysqli_fetch_assoc($result_for_get_maker); 
                $response = [
                    'error_code' => 200,
                    'data' => $maker_details,
                    'data_from' => 'mk'
                ];
            } else {
                $response = [
                    'error_code' => 500
                ];
            }
        }
    } 
    
    // Fetch maker details based on equipment ID
    else if($mode == 4) {
        if (!isset($_POST['eq_id'])) {
            echo json_encode(['error_code' => 400, 'message' => 'Missing required fields']);
            exit;
        }
        
        $eq_id = $_POST['eq_id'];
        $query_for_get_maker = "SELECT m_id, model_name, maker_name, maker_address FROM modal_maker_header_all WHERE eq_id = '$eq_id'";
        $result_for_get_maker = $conn->query($query_for_get_maker);
        
        if ($result_for_get_maker && mysqli_num_rows($result_for_get_maker) == 1) {
            $maker_details = mysqli_fetch_assoc($result_for_get_maker); 
            $response = [
                'error_code' => 200,
                'data' => $maker_details,
                'data_from' => 'mk'
            ];
        } else {
            $response = [
                'error_code' => 500,
                'query' => $query_for_get_maker
            ];
        }    
    }
}

// Return JSON response
echo json_encode($response);
?>
