const statusMap = {
    "All Requisitions": "ALL",
    "Generated Requisitions": [1],
    "Drafted Requisitions": [0],
    "Accepted Requisitions": [2],
    "Operational Requisitions": [2, 4, 5],
    "Rejected Requisitions": [3],
    "Order Placed": [2, 4],
    "Order Received": [4],
    "Order Closed": [5]
};

let requisitions = [];
let shipList = [];
let selectedShipId = "";

// Script to fetch reequisition data 
function fetchRequisitions() {
    $.ajax({
        url: './ajax/json_for_summary_report_v1_0.php',
        method: 'GET',
        data: { ship_id: selectedShipId },
        dataType: 'json',
        success: function (response) {
            if (response.error_code === 200) {
                shipList = response.ships || [];
                populateShipDropdown();
window.reportMeta = response.report_meta || {}; 
                requisitions = response.data.map(r => ({
                    id: r.id,
                    req_no: r.req_no,
                    dept: r.dept,
                    type: r.type,
                    status_code: parseInt(r.status_code),
                    status: r.status,
                    date: r.date,
                    title: r.title || '',
                    received_date: r.received_date || '',
                    place: r.place || '',
                    remark: r.remark || ''
                }));


                renderCards();
            } else {
                alert("Failed to fetch requisitions.");
            }
        },
        error: function () {
            alert("Error fetching requisitions.");
        }
    });
}

// script for ship dropdown
function populateShipDropdown() {
    const dropdown = $('#shipSelect');
    dropdown.empty().append(`<option value="">-- All Ships --</option>`);
    shipList.forEach(ship => {
        dropdown.append(`<option value="${ship.ship_id}">${ship.ship_name}</option>`);
    });
    dropdown.val(selectedShipId);
}

// function for status cards
function renderCards() {
    const container = $('#statusCards');
    container.empty();

    Object.entries(statusMap).forEach(([status, codes]) => {
        let count = (codes === "ALL") ? requisitions.length :
            requisitions.filter(r => codes.includes(r.status_code)).length;

        container.append(`
            <div class="request-card status-card" data-status="${status}">
                <h5>Status: ${status}</h5>
                <h5>Count: ${count}</h5>
            </div>
        `);
    });
}

// Table render on card click
$(document).on('click', '.status-card', function () {
    const status = $(this).data('status');
    const codes = statusMap[status];
    const filtered = (codes === "ALL") ? requisitions : requisitions.filter(r => codes.includes(r.status_code));

    const today = new Date();
    const formattedDate = today.toLocaleDateString('en-GB'); 
    $('#currentDate').text(formattedDate);

    const selectedShipName = $('#shipSelect option:selected').text();
    $('#selectedShipName').text(selectedShipName.trim() === "-- All Ships --" ? "All Ships" : selectedShipName);

    $('#selectedStatusTitle').text(`Requisitions with Status: ${status}`);

    const tbody = $('#detailsTable tbody');
    tbody.empty();

    filtered.forEach((r, index) => {
        tbody.append(`
            <tr>
                <td>${index + 1}</td>
                <td>${r.req_no}</td>
                <td>${r.dept}</td>
                <td>${r.type}</td>
                <td>${r.date}</td>
                <td>${r.title}</td>
                <td>${r.status}</td>
                <td>${r.received_date || ''}</td>
                <td>${r.place || ''}</td>
                <td>${r.remark || ''}</td>
            </tr>
        `);
    });

    $('#detailsSection').show();
});


// Script for filter data by ship
$('#shipSelect').on('change', function () {
    selectedShipId = $(this).val();
    fetchRequisitions();
});


// Script for pdf generation
// Utility: Convert image to base64
async function toDataURL(url) {
    const response = await fetch(url);
    const blob = await response.blob();
    return new Promise((resolve) => {
        const reader = new FileReader();
        reader.onloadend = () => resolve(reader.result);
        reader.readAsDataURL(blob);
    });
}

$('#downloadDetailsPdf').on('click', async function () {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF();
    const pageWidth = doc.internal.pageSize.getWidth();
    const margin = 10;

    const logoUrl = "assets/images/logo/ksm_logo.jpg";
    const logoX = margin;
    const logoY = 10;
    const logoWidth = 20;
    const logoHeight = 15;
    const imageData = await toDataURL(logoUrl);
    doc.addImage(imageData, 'JPEG', logoX, logoY, logoWidth, logoHeight);

    // Fetch report metadata from JSON (response.report_meta)
    const meta = {
    report_name: window.reportMeta?.report_name,
    report_code: window.reportMeta?.report_code,
    revision_number: window.reportMeta?.revision_number,
    created_date: window.reportMeta?.created_date,
    approved_by: window.reportMeta?.approved_by,
    prepared_by: window.reportMeta?.prepared_by
};

    // Header
    doc.setFont("helvetica", "bold");
    doc.setFontSize(10);

    const leftXTop = (pageWidth / 2) - (doc.getTextWidth(meta.report_name) / 2);
    const leftXBottom = (pageWidth / 2) - (doc.getTextWidth(meta.report_code) / 2);
    doc.text(meta.report_name, leftXTop, logoY + 5);
    doc.text(meta.report_code, leftXBottom, logoY + 9);

    const rightTextTOP = `REV.NO. ${meta.revision_number}`;
    const rightTextBottom = `DATE: ${meta.created_date}`;

    const rightXTop = pageWidth - margin - doc.getTextWidth(rightTextTOP);
    const rightXBottom = pageWidth - margin - doc.getTextWidth(rightTextBottom);

    doc.text(rightTextTOP, rightXTop, logoY + 5);
    doc.text(rightTextBottom, rightXBottom, logoY + 9);


    // Line separator
    doc.setLineWidth(0.5);
    doc.line(margin, logoY + logoHeight + 4, pageWidth - margin, logoY + logoHeight + 4);

    const today = new Date();
    const formattedDate = today.toLocaleDateString('en-GB');
    doc.setFontSize(9);
    doc.text(`Date: ${formattedDate}`, margin, logoY + logoHeight + 10);
    const selectedShipName = $('#shipSelect option:selected').text().trim();
    doc.text(`Ship Name: ${selectedShipName === "-- All Ships --" ? "All Ships" : selectedShipName}`, pageWidth - margin - 3, logoY + logoHeight + 10, { align: "right" });

    // Table
    const headers = [["Sr No.", "RQSN Number", "Department", "Type", "Date Issued", "Title / Brief Description", "Status", "Received Date", "Place", "Remark"]];
    const body = [];

    $('#detailsTable tbody tr').each(function () {
        const row = [];
        $(this).find('td').each(function () {
            row.push($(this).text().trim());
        });
        body.push(row);
    });

    const startY = logoY + logoHeight + 15;
    doc.autoTable({
        head: headers,
        body: body,
        startY: startY,
        theme: 'grid',
        styles: { fontSize: 8, cellPadding: 2 },
        headStyles: {
            fillColor: [200, 200, 200],
            textColor: 0,
            fontStyle: 'bold',
            halign: 'center'
        },
        margin: { left: margin, right: margin },
    });

    // Footer
    const footerY = doc.internal.pageSize.getHeight() - 15;
    doc.setFontSize(9);

    doc.text("SHIP", margin, footerY);
    const centerX = pageWidth / 2;
    doc.text(`Approved by: ${meta.approved_by}`, centerX, footerY, { align: "center" });

    const pageNumber = doc.internal.getCurrentPageInfo().pageNumber;
    const rightXy = pageWidth - margin - 5;
    doc.text(`Issued by ${meta.prepared_by} /${pageNumber}`, rightXy, footerY, { align: "right" });

    // Filename
    let serialNumber = localStorage.getItem('serialNumber');
    serialNumber = serialNumber ? parseInt(serialNumber) + 1 : 1;
    localStorage.setItem('serialNumber', serialNumber);

    const serialFormatted = String(serialNumber).padStart(3, '0');
    const digit = String(today.getDate()).padStart(2, '0');
    const monthdigit = String(today.getMonth() + 1).padStart(2, '0');
    const yearDigits = String(today.getFullYear()).slice(-2);
    const dateCode = `${digit}${monthdigit}${yearDigits}`;

    const fileName = `req_summary_report_${serialFormatted}${dateCode}.pdf`;
    doc.save(fileName);
});


$(document).ready(function () {
    fetchRequisitions();
});
