// Date : 24-03-2025

// Handle the response from the login API.
const checkLogin = () => {

    var formData = {
        user_name: $("#userId").val(),
        pass: $("#userPassword").val(),
        user_type: "1" // Change this as per requirement
    };

    $.ajax({
        url: "./ajax/json_for_login_v1_0.php", 
        type: "POST",
        data: formData,
        dataType: "json",
        success: function (response) {
            let warningDiv = $("#loginWarning");
            warningDiv.hide().removeClass("alert-danger alert-success");

            switch (response.error_code) {
                case 200:
                    warningDiv.addClass("alert-success").text("Login successful! Redirecting...").show();

                    // Store token in local storage for future authentication
                    sessionStorage.setItem("authToken", response.token);

                    // Redirect user to dashboard or another page
                    setTimeout(() => {
                        window.location.href = "index.php"; // Change as needed
                    }, 1500);
                    break;

                case 100:
                    warningDiv.addClass("alert-danger").text("Invalid credentials. Please try again.").show();
                    break;

                case 400:
                    warningDiv.addClass("alert-danger").text("Missing required fields.").show();
                    break;

                case 500:
                    warningDiv.addClass("alert-danger").text("Server error! Please try again later.").show();
                    break;

                default:
                    warningDiv.addClass("alert-danger").text("Unexpected error occurred.").show();
                    break;
            }
        },
        error: function () {
            $("#loginWarning").addClass("alert-danger").text("Failed to connect to the server.").show();
        }
    });
};
