<?php
session_start();
require_once './includes/header.php';

$requisition_id = isset($_GET['requisition_id']) ? $_GET['requisition_id'] : '';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="assets/css/style_for_requisition_items.css">
</head>
<body class="with-welcome-text">
    <div class="container-scroller">
        <!-- partial:partials/_navbar.html -->
        <?php include './includes/profilebasenavbar.php'; ?>
        <!-- partial -->
        <div class="container-fluid page-body-wrapper">
            <!-- partial:partials/_sidebar.html -->
            <?php include './includes/sidebarmenu.php'; ?>
            <!-- partial -->
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="home-tab">
                                <div class="tab-content tab-content-basic" style="padding: 0;">
                                    <div class="tab-pane fade show active" id="overview" role="tabpanel" aria-labelledby="overview">
                                        <div class="container form-container" id="requisition-details-container">
                                            <!-- Requisition details will be populated here by JavaScript -->
                                        </div>

                                        <!-- Display the Added Items Table directly -->
                                        <div class="container form-container" style="margin-top: 20px;">
                                            <div class="mt-3">
                                                <table class="table table-bordered table-sm text-center align-middle" id="itemTable">
                                                    <thead class="table-light">
                                                        <tr>
                                                            <th class="hidden-column">Item Id</th>
                                                            <th>Item Name</th>
                                                            <th>Drawing No</th>
                                                            <th>Part No</th>
                                                            <th style="width: 100px;">Working Qty</th>
                                                            <th style="width: 100px;">ROB</th>
                                                            <th style="width: 100px;">Req Qty</th>
                                                            <th style="width: 100px;">Accepted Qty</th>
                                                            <th style="width: 200px;">Remark</th>
                                                            <th>Action</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="itemListContainer">
                                                        <!-- Items will be inserted here dynamically by JavaScript -->
                                                    </tbody>
                                                </table>
                                            </div>
                                            <div class="mt-3 d-flex justify-content-center">
                                                <button class="btn btn-outline-secondary btn-sm" onclick="window.location.href='generated_request.php';">Back</button>
                                                <button class="btn btn-outline-success accept-btn btn-sm" data-requisition-id="<?php echo $requisition_id; ?>">Accept</button>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include './includes/footer.php'; ?>
            </div>
        </div>
    </div>
    <?php include './includes/dependancy.php'; ?>
</body>

<!-- Modal Structure for Accept Warning -->
<div class="modal-overlay" id="acceptWarning" style="display: none;">
    <div class="modal-box">
        <div class="modal-header">
            Important Notice
            <button onclick="closeAcceptWarning();" style="width: 10%;">&times;</button>
        </div>
        <div class="modal-body">
            Are you sure you want to accept this requisition?
        
        <div class="modal-body text-center mt-1">
            <button class="btn btn-outline-info btn-sm" onclick="closeAcceptWarning();">Cancel</button>
            <button class="btn btn-outline-success btn-sm" id="confirmAcceptBtn">YES</button> 
        </div>  
        </div>
    </div>
</div>

<!-- Modal for Requisition Accepted -->
<div class="modal-overlay" id="acceptedModal" style="display: none;">
    <div class="modal-box">
            <div class="modal-body text-center">
                <h5 class="modal-title">Requisition Accepted Successfully..!</h5>
                <div class="modal-body text-center">
                    <button class="btn btn-outline-success btn-sm" id="okBtn">OK</button>
                </div>
            </div>
    </div>
</div>

<script src="assets/js/generatedRequisition.js"></script>
</html>