<?php
require_once "./config/test.php";

$conn = SqlServerConnection::getConnection();

$query = "SELECT * FROM vendor_header_all";
$stmt = sqlsrv_query($conn, $query);

if ($stmt === false) {
    die(print_r(sqlsrv_errors(), true));
}

echo "<h2>Vendor Table Data:</h2>";

echo "<style>
    table { border-collapse: collapse; width: 100%; }
    th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
    th { background-color: #f2f2f2; }
</style>";

echo "<table>";
$firstRow = true;

while ($row = sqlsrv_fetch_array($stmt, SQLSRV_FETCH_ASSOC)) {
    if ($firstRow) {
        echo "<tr>";
        foreach (array_keys($row) as $columnName) {
            echo "<th>" . htmlspecialchars($columnName) . "</th>";
        }
        echo "</tr>";
        $firstRow = false;
    }

    echo "<tr>";
    foreach ($row as $value) {
        if ($value instanceof DateTime) {
            $value = $value->format('Y-m-d H:i:s'); 
        }
        echo "<td>" . htmlspecialchars((string)$value) . "</td>";
    }
    echo "</tr>";
}

echo "</table>";

SqlServerConnection::closeConnection();
?>
