<?php
session_start();
require_once './includes/header.php';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <link rel="stylesheet" href="assets/css/style_for_generated_requisitions.css">
</head>

<body class="with-welcome-text">
    <div class="container-scroller">
        <?php include './includes/profilebasenavbar.php'; ?>
        <div class="container-fluid page-body-wrapper">
            <?php include './includes/sidebarmenu.php'; ?>
            <div class="main-panel">
                <div class="content-wrapper">
                    <div class="row">
                        <div class="col-sm-12">
                            <div class="home-tab">
                                <div class="tab-content tab-content-basic" style="padding: 0;">
                                    <div class="tab-pane fade show active" id="overview">
                                        <!-- Container for status cards -->
                                        <div class="container form-container">
                                            <div class="d-flex justify-content-between align-items-center mb-3">
                                                <h2 class="mb-0">Requisition Summary Report</h2>
                                                <div class="form-group mb-0">
                                                    <label for="shipSelect" class="form-label me-2"><strong>Select Ship:</strong></label>
                                                    <select id="shipSelect" class="form-control d-inline-block w-auto" style="height:30px;">
                                                        <option value="">-- All Ships --</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="status-grid" id="statusCards"></div>
                                        </div>

                                        <div class="container form-container" id="detailsSection" style="display: none;">
                                            <h4 id="selectedStatusTitle" class="mb-3"></h4>
                                            <div class="d-flex justify-content-between mb-2">
                                                <div><strong>Date:</strong> <span id="currentDate"></span></div>
                                                <div><strong>Ship Name:</strong> <span id="selectedShipName"></span></div>
                                            </div>

                                            <div class="table-wrapper">
                                                <table id="detailsTable" class="table datatable">
                                                    <thead>
                                                        <tr>
                                                            <th>Sr No.</th>
                                                            <th>RQSN Number</th>
                                                            <th>Department</th>
                                                            <th>Type</th>
                                                            <th>Date Issued</th>
                                                            <th>Title / Brief Description</th>
                                                            <th>Status</th>
                                                            <th>Received Date</th>
                                                            <th>Place</th>
                                                            <th>Remark</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody></tbody>
                                                </table>
                                            </div>

                                            <div class="text-center">
                                                <button id="downloadDetailsPdf" class="btn btn-outline-primary mt-2">Download as PDF</button>
                                            </div>
                                        </div>


                                        
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php include './includes/footer.php'; ?>
            </div>
        </div>
    </div>
    <?php include './includes/dependancy.php'; ?>
</body>
</html>

<script src="assets/js/summaryReport.js"></script>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.29/jspdf.plugin.autotable.min.js"></script>