<?php 
/*
objective : This API retrieves hierarchical category and item data including departments, categories, sub-categories, and second-level sub-categories. It also fetches specific item details based on item_name if provided via GET.
file version : 1.0
API NO : KDN02
Date of creation : 05/05/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone :

Date  : 06/05/2025

Request Method:
Type: GET

Headers: Content-Type: application/json

Request Parameters (Optional):
item_name (string) – Name of the item to fetch its drawing and part number.

***********

Execution Process

*Step 1: Database Connection
- Establishes a connection using a defined SqlServerConnection class.
- If connection fails, returns error_code 500.

*Step 2: Item Details Fetch (if item_name is provided)
- Queries the item_header_all table using the provided item_name.
- If query fails, returns error_code 501.
- If no result is found, returns null values.

*Step 3: Department Fetch
- Retrieves departments from department_header_all.
- If query fails, returns error_code 502.

*Step 4: Category and Item Hierarchy
- Fetches categories and their sub-categories.
- Each sub-category retrieves second-level sub-categories and items with requisition_type = 1.
- If any sub-query fails, returns error_code 503.

*Step 5: Flat Item List
- Fetches items where requisition_type = 2 from item_header_all.
- If query fails, returns error_code 504.

********

Response Structure

*Success Response
{
    "error_code": 200,
    "departments": [...],
    "categories": [...],
    "flatItems": [...]
}

*Failure Responses

error_code: 500
message: "SQL Server connection failed"

error_code: 501
message: "Item query failed"

error_code: 502
message: "Department query failed"

error_code: 503
message: "Category or Sub-category query failed"

error_code: 504
message: "Flat items query failed"

-------------------------------------------------------------------------------------------------------------------------------

Date :

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone :

Date : 

*/

session_start();
require_once '../config/config.php';

$conn = SqlServerConnection::getConnection();
header('Content-Type: application/json');

if ($conn === false) {
    die(json_encode([
        'error_code' => 500,
        'error' => 'SQL Server connection failed',
        'details' => sqlsrv_errors()
    ]));
}

$type = isset($_GET['type']) ? $_GET['type'] : null;

if (isset($_GET['item_name'])) {
    $item_name = $_GET['item_name'];

    $sql = "SELECT item_drawing_no, item_part_no FROM item_header_all WHERE item_name = N'$item_name'";
    $result = sqlsrv_query($conn, $sql);

    if ($result === false) {
        echo json_encode([
            'error_code' => 501,
            'item_drawing_no' => null,
            'item_part_no' => null,
            'message' => 'Item query failed'
        ]);
        exit;
    }

    $row = sqlsrv_fetch_array($result, SQLSRV_FETCH_ASSOC);
    echo json_encode([
        'error_code' => 200,
        'item_drawing_no' => $row['item_drawing_no'] ?? null,
        'item_part_no' => $row['item_part_no'] ?? null
    ]);
    exit;
}

// Fetch departments
$departments = [];
$sql_dept = "SELECT dept_id, dept_name FROM department_header_all";
$dept_result = sqlsrv_query($conn, $sql_dept);

if ($dept_result === false) {
    die(json_encode([
        'error_code' => 502,
        'error' => 'Department query failed',
        'details' => sqlsrv_errors()
    ]));
}

while ($row = sqlsrv_fetch_array($dept_result, SQLSRV_FETCH_ASSOC)) {
    $departments[] = $row;
}

// type = 1 

$categories = [];
$flatItems = [];
$indexedCategories = [];
if($type == 1) {
$sql_hierarchy = "
SELECT 
    ch.cat_id, ch.cat_name,
    sch.sub_cat_id, sch.sub_cat_name,
    ssch.sec_sub_cat_id, ssch.sec_sub_cat_name,
    tsch.third_sub_cat_id, tsch.third_sub_cat_name,
    ih.item_id, ih.item_name
FROM category_header_all ch
LEFT JOIN sub_category_header_all sch ON ch.cat_id = sch.cat_id
LEFT JOIN second_sub_category_header_all ssch ON sch.sub_cat_id = ssch.sub_cat_id
LEFT JOIN third_sub_category_header_all tsch ON ssch.sec_sub_cat_id = tsch.sec_sub_cat_id
LEFT JOIN item_header_all ih ON tsch.third_sub_cat_id = ih.third_sub_cat_id AND ih.type = 1
";

$hierarchy_result = sqlsrv_query($conn, $sql_hierarchy);

if ($hierarchy_result === false) {
    die(json_encode([
        'error_code' => 503,
        'error' => 'Category or Sub-category query failed',
        'details' => sqlsrv_errors()
    ]));
}

$categories = [];

while ($row = sqlsrv_fetch_array($hierarchy_result, SQLSRV_FETCH_ASSOC)) {
    $cat_id = $row['cat_id'];
    $sub_cat_id = $row['sub_cat_id'];
    $sec_sub_cat_id = $row['sec_sub_cat_id'];
    $third_sub_cat_id = $row['third_sub_cat_id'];
    $item_id = $row['item_id'];

    if (!isset($categories[$cat_id])) {
        $categories[$cat_id] = [
            'cat_id' => $cat_id,
            'cat_name' => $row['cat_name'],
            'sub_categories' => []
        ];
    }

    if ($sub_cat_id && !isset($categories[$cat_id]['sub_categories'][$sub_cat_id])) {
        $categories[$cat_id]['sub_categories'][$sub_cat_id] = [
            'sub_cat_id' => $sub_cat_id,
            'sub_cat_name' => $row['sub_cat_name'],
            'second_sub_categories' => []
        ];
    }

    if ($sec_sub_cat_id && !isset($categories[$cat_id]['sub_categories'][$sub_cat_id]['second_sub_categories'][$sec_sub_cat_id])) {
        $categories[$cat_id]['sub_categories'][$sub_cat_id]['second_sub_categories'][$sec_sub_cat_id] = [
            'sec_sub_cat_id' => $sec_sub_cat_id,
            'sec_sub_cat_name' => $row['sec_sub_cat_name'],
            'third_sub_categories' => []
        ];
    }

    if ($third_sub_cat_id && !isset($categories[$cat_id]['sub_categories'][$sub_cat_id]['second_sub_categories'][$sec_sub_cat_id]['third_sub_categories'][$third_sub_cat_id])) {
        $categories[$cat_id]['sub_categories'][$sub_cat_id]['second_sub_categories'][$sec_sub_cat_id]['third_sub_categories'][$third_sub_cat_id] = [
            'third_sub_cat_id' => $third_sub_cat_id,
            'third_sub_cat_name' => $row['third_sub_cat_name'],
            'items' => []
        ];
    }

    if ($item_id) {
        $categories[$cat_id]['sub_categories'][$sub_cat_id]['second_sub_categories'][$sec_sub_cat_id]['third_sub_categories'][$third_sub_cat_id]['items'][] = [
            'item_id' => $item_id,
            'item_name' => $row['item_name']
        ];
    }
}

$indexedCategories = array_values(array_map(function($cat) {
    $cat['sub_categories'] = array_values(array_map(function($sub) {
        $sub['second_sub_categories'] = array_values(array_map(function($sec) {
            $sec['third_sub_categories'] = array_values($sec['third_sub_categories']);
            return $sec;
        }, $sub['second_sub_categories']));
        return $sub;
    }, $cat['sub_categories']));
    return $cat;
}, $categories));


} else if($type == 2) {
// type = 2

$sql_flat = "SELECT item_id, item_name, item_part_no, uom FROM item_header_all WHERE type = 2";
$flat_result = sqlsrv_query($conn, $sql_flat);

if ($flat_result === false) {
    die(json_encode([
        'error_code' => 504,
        'error' => 'Flat items query failed',
        'details' => sqlsrv_errors()
    ]));
}

while ($item = sqlsrv_fetch_array($flat_result, SQLSRV_FETCH_ASSOC)) {
    $flatItems[] = $item;
}
}

$response = [
    'error_code' => 200,
    'departments' => $departments,
    'categories' => $indexedCategories,
    'flatItems' => $flatItems
];

echo json_encode($response, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);
?>