const addItemToRequisitionHeader = (req_no, user_token) => {
    // Collect form data
    const formData = {
        req_no: req_no
    };

    $.ajax({
        url: "./ajax/json_for_submit_requisition_header_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded", // Explicitly setting content type
        headers: {
            "token_id": user_token, // Pass token in headers
            "mode":"2"
        },
        success: function (response) {
            if (response.error_code === 200) {
                let data = response.data;
                let subCat = response.sub_cat;

                $("#vesselName").text(data.ship_name);
                $("#deptName").text(data.dept_name);
                $("#eqName").text(`${data.eq_name} (${data.eq_engine_type})`);
                $("#modelName").text($.trim(data.model_name));
                $("#makerName").text(data.maker_name);
                $("#address").text(data.maker_address);
                $("#priorityLevel").text(data.req_priority === "1" ? "Normal" : "Urgent");
                $("#category").text(data.cat_name);

            let subCategorySelect = $("#categorySelect"); // Replace with actual ID
            subCategorySelect.empty().append('<option value="" selected disabled>-- Select Subcategory --</option>');

            if (Array.isArray(subCat) && subCat.length > 0) {
                subCat.forEach(sub => {
                    subCategorySelect.append(`<option value="${sub.sub_cat_id}">${sub.sub_cat_name}</option>`);
                });
            }


            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });
};


// for show item list of sub category 

let currentPage = 1;
var currentItems ;
const itemsPerPage = 10;
const renderItemsList = (subCatId, user_token, req_no, page = 1) => {
    
    user_token = user_token;
    const formData = {
        sub_cat_id: subCatId,
        req_no: req_no,
        page: page, // Send page number to API
        limit: itemsPerPage // Number of items per page
    };

    $.ajax({
        url: "./ajax/json_for_submit_requisition_header_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": user_token, // Pass token in headers
            "mode": "3"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {
                let data = response.data;
                let item = response.items;

                let totalItems = response.total_items; // Assuming the API returns the total count

                currentItems = data; // Update current items
                console.log(currentItems);
                currentPage = page; // Update current page
                displayPage(user_token, req_no, item);
                renderPagination(totalItems, subCatId, user_token, req_no); // Call pagination with total items
            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });
};
// Function to display items for the current page
const displayPage = (userToken, reqNo, items) => {
    const container = document.getElementById('itemListContainer');
    container.innerHTML = '';

    console.log(items);

    if (currentItems.length === 0) {
        container.innerHTML = `<tr><td colspan="8" class="text-muted">No items available.</td></tr>`;
        return;
    }

    currentItems.forEach(item => {
        let isExisting = items.includes(item.item_id);
    
        container.innerHTML += `
            <tr class="${isExisting ? 'table-success' : ''}">
                <td class="hidden-column">${item.item_id}</td>
                <td>${item.item_name}</td>
                <td>${item.item_drawing_no}</td>
                <td>${item.item_part_no}</td>
                <td><input type="text" class="form-input form-control-sm" min="1" ${isExisting ? 'disabled' : ''}></td>
                <td><input type="text" class="form-input form-control-sm" min="1" ${isExisting ? 'disabled' : ''}></td>
                <td><input type="text" class="form-input form-control-sm" min="1" ${isExisting ? 'disabled' : ''}></td>
                <td><input type="text" class="form-input form-control-sm" ${isExisting ? 'disabled' : ''}></td>
                <td>
                    <button class="btn ${isExisting ? 'btn-success' : 'btn-outline-primary'} btn-sm" 
                        onclick="addItemToRequisition('${item.item_name}', '${userToken}', '${reqNo}')" 
                        ${isExisting ? 'disabled' : ''}>
                        ${isExisting ? '✔️ Added' : '➕'}
                    </button>
                </td>
            </tr>
        `;
    });
    
    
}

// Function to render pagination
const renderPagination = (totalItems, subCatId, user_token, req_no) => {
    const totalPages = Math.ceil(totalItems / itemsPerPage);
    const pagination = document.getElementById('paginationContainer');
    pagination.innerHTML = '';

    for (let i = 1; i <= totalPages; i++) {
        pagination.innerHTML += `
            <button class="btn btn-sm ${i === currentPage ? 'btn-primary' : 'btn-outline-primary'}" onclick="gotoPage(${subCatId}, '${user_token}', ${i}, '${req_no}')">${i}</button> 
        `;
    }
}

// Function to go to a specific page
const gotoPage = (subCatId, user_token, page, req_no) => {
    renderItemsList(subCatId, user_token, req_no, page); // Fetch data for the selected page
}

const addItemToRequisition = (itemName,user_token,req_no) => {
        // Get the clicked button's row
        let row = event.target.closest("tr");
        let itemId = row.querySelector(".hidden-column").textContent.trim();
        
        // Extract values from input fields
        let workingQty = row.cells[4].querySelector("input").value.trim();
        let rob = row.cells[5].querySelector("input").value.trim();
        let reqQty = row.cells[6].querySelector("input").value.trim();
        let remark = row.cells[7].querySelector("input").value.trim();

        const selectedCategory = document.getElementById("categorySelect").value;

        const formData = {
            req_no: req_no,
            sub_cat_id: selectedCategory,
            item_id: itemId,
            working_qty: workingQty,
            rob: rob,
            req_qty: reqQty,
            remark: remark
        };

        $.ajax({
            url: "./ajax/json_for_submit_requisition_header_v1_0.php",
            type: "POST",
            data: $.param(formData), // Serialize data
            dataType: "json",
            contentType: "application/x-www-form-urlencoded",
            headers: {
                "token_id": user_token, // Pass token in headers
                "mode": "4"
            },
            success: function (response) {
                if (response.error_code === 200) {

                    // Disable all input fields inside the row
                    row.querySelectorAll("input").forEach(input => {
                        input.disabled = true;
                    });


                    row.classList.add('table-success');
                    const button = row.querySelector('button');
                    button.classList.remove('btn-outline-primary');
                    button.classList.add('btn-success');
                    button.innerText = '✔️ Added';
                    button.disabled = true;

                } else {
                    // alert('Error: ' + response.message);
                    alert('Error: Check your network or try after some time');
                }
            },
            error: function (xhr, status, error) {
                console.log("AJAX Error: ", status, error);
                console.log("Response Text: ", xhr.responseText);
                alert("Server error. Please check the console.");
            }
        });
    
        // You can now send this data via AJAX, update a table, etc.    
}

const showAddedItemsToReq = (usrToken, reqNo) => {
    // pending
    // mode 5
    const formData = {
        req_no: reqNo
    };

    $.ajax({
        url: "./ajax/json_for_submit_requisition_header_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": usrToken, // Pass token in headers
            "mode": "5"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {
                populateModal(usrToken, reqNo, response.data);
                $("#itemsModal").modal("show");

            } else if(response.error_code === 700){
alert("Item list is empty please add item in it");
            } else {
                // alert('Error: ' + response.message);
                alert('Error: Check your network or try after some time');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });

}

const submitFinalRequisition = (usrToken, reqNo) => {
    // alert("Are you sure..!");

    const formData = {
        req_no: reqNo
    };

    $.ajax({
        url: "./ajax/json_for_submit_requisition_header_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": usrToken, // Pass token in headers
            "mode": "6"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {

                alert("Requisition sent to admin, please wait for response");
                window.location.href = 'index.php';

            } else if(response.error_code === 700) {
    alert("Please add items");
            } else {
                // alert('Error: ' + response.message);
                alert('Error: Check your network or try after some time');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });
}


const populateModal = (usrToken, reqNo, data) => {
    let modalBody = document.getElementById("modalBody");
    modalBody.innerHTML = ""; // Clear previous content

    if(data.length > 0){

    data.forEach(subCat => {
        let subCatTitle = `<h5 style = "margin-top: 16px;font-size: 20px;font-weight: 900;color: blue;">${subCat.sub_cat_name}</h5>`;
        let table = `
            <table class="table table-bordered">
                <thead>
                    <tr class = "text-center">
                        <th>Sr. No</th>
                        <th>Item Name</th>
                        <th>Drawing No</th>
                        <th>Part No</th>
                        <th>Working Qty</th>
                        <th>ROB</th>
                        <th style = "width: 10%;">Req Qty</th>
                        <th>Remark</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>`;

        let totalItems = 0;
        subCat.items.forEach((item, index) => {
            totalItems++;
            table += `
                <tr id="row-${item.item_details.item_id}" style = "border-bottom: 1px solid lightblue;">
                    <td class = "text-center">${index + 1}</td>
                    <td class = "text-center">${item.item_details.item_name}</td>
                    <td class = "text-center">${item.item_details.item_drawing_no}</td>
                    <td class = "text-center">${item.item_details.item_part_no}</td>
                    <td class = "text-center">${item.item_details.working_qty}</td>
                    <td class = "text-center">${item.item_details.rob}</td>
                    <td class = "text-center"><input type="number" class="req-qty" value="${item.item_details.req_qty}" id="reqQty-${item.item_details.item_id}" style = "margin-bottom:0px;"></td>
                    <td class = "text-center">${item.item_details.remark}</td>
                    <td class="text-center">
                        <button class="btn btn-success btn-sm" title = "Upadte" onclick="updateItem('${usrToken}', '${reqNo}', ${subCat.sub_cat_id}, ${item.item_details.item_id}, 0)">
                            <i class="fa fa-edit"></i></button>
                        <button class="btn btn-danger btn-sm" title = "Delete" onclick="updateItem('${usrToken}', '${reqNo}', ${subCat.sub_cat_id}, ${item.item_details.item_id}, 2)">
                            <i class="fa fa-trash"></i></button>
                    </td>
                </tr>`;
        });

        table += `
                </tbody>
                <tfoot>
                    <tr>
                        <td colspan="8" class="text-right"><b>Total Items:</b></td>
                        <td><b>${totalItems}</b></td>
                    </tr>
                </tfoot>
            </table>`;
        
        modalBody.innerHTML += subCatTitle + table;
    });
}else {
    alert("Item note added to this Requisition, Please add first item to it.")
}
};

const updateItem = (usrToken, reqNo, subCatId, itemId, status) => {
    let reqQty = document.getElementById(`reqQty-${itemId}`).value;
    // Implement AJAX update logic here

    const formData = {
        req_no: reqNo,
        sub_cat_id: subCatId,
        item_id: itemId,
        req_qty: reqQty,
        status: status
    };

    $.ajax({
        url: "./ajax/json_for_submit_requisition_header_v1_0.php",
        type: "POST",
        data: $.param(formData), // Serialize data
        dataType: "json",
        contentType: "application/x-www-form-urlencoded",
        headers: {
            "token_id": usrToken, // Pass token in headers
            "mode": "7"
        },
        success: function (response) {
            console.log(response);
            if (response.error_code === 200) {
                alert("Qntity Update successfully");
            } else if (response.error_code === 600) {
                alert("Item removed successfully");
                showAddedItemsToReq(usrToken, reqNo); 
            } else {
                // alert('Error: ' + response.message);
                alert('Error: Check your network or try after some time');
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });


};

const deleteItem = (itemId) => {
    // let row = document.getElementById(`row-${itemId}`);
    // if (row) row.remove();
    alert(`Item ID ${itemId} deleted`);
    // Implement AJAX delete logic here
};
