<?php
/*
objective : This API handles the creation and retrieval of categories within specific departments. 
It supports adding new categories to a department and fetching categories with pagination and optional search functionality.

file version : 1.0
API NO : KDN03
Date of creation : 27/03/2025

xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Logic Zone : 

Date  : 27/03/2025

Request Method
Type: POST, GET

Headers: Content-Type: application/json

Request Parameters
- For POST:
  - dept_id (int, required) – The ID of the department.
  - cat_name (string, required) – The name of the category.

- For GET:
  - action (string, optional) – Specifies action type ('fetch_departments' to fetch department details).
  - dept_id (int, optional) – The department ID for which categories are to be retrieved.
  - search (string, optional) – Search query for filtering category names.
  - page (int, optional) – The page number for pagination. Default is 1.

Authentication: No authentication is required for this API.

***********

Authentication Process

* Step 1: Input Validation
  - For POST, it checks if both the department ID and category name are provided.
  - For GET, it checks for the department ID and search parameters, if provided, and applies pagination.

* Step 2: Duplicate Check (POST only)
  - It checks if the category already exists within the specified department.
  - If the category exists, an error response is returned.

* Step 3: Inserting Category (POST only)
  - If no duplicate is found, a new category is inserted into the database along with the department ID.
  
* Step 4: Fetching Category Data (GET only)
  - For GET requests, it returns a paginated list of categories, optionally filtered by department and search query.
  - It calculates the total number of pages for pagination based on the number of matching categories.

***********

Response Structure

* Success Response
  - For POST:
    - success_code: 200 (indicating success)
    - message: 'Category added successfully'

  - For GET:
    - error_code: 200 (indicating success)
    - data: Array of category details
    - total_pages: Total number of pages for pagination
    - current_page: The current page number

* Failure Responses:
  - For POST:
    - error_code: 100 (Category already exists in this department)
    - error_code: 400 (Missing required department ID or category name)
    - error_code: 102 (Error while adding category)

  - For GET:
    - error_code: 101 (No categories found)
    - error_code: 300 (Invalid request method)

Date :
xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx

Error Zone : 

Date : 
*/

session_start();
require_once("../config/config.php");

$itemsPerPage = 5;

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['dept_id']) && isset($_POST['cat_name']) && !empty($_POST['dept_id']) && !empty($_POST['cat_name'])) {
        $conn = connection::getConnection();

        // Sanitize input to prevent SQL injection
        $dept_id = mysqli_real_escape_string($conn, $_POST['dept_id']);
        $cat_name = mysqli_real_escape_string($conn, $_POST['cat_name']);
        $cat_status = 1; // Active status
        $cat_date_of_creation = date('Y-m-d H:i:s');

        // Check if category already exists for this department
        $checkCategoryQuery = "SELECT * FROM category_header_all WHERE dept_id = '$dept_id' AND cat_name = '$cat_name'";
        $checkResult = mysqli_query($conn, $checkCategoryQuery);
        if (mysqli_num_rows($checkResult) > 0) {
            echo json_encode(['error_code' => 100, 'message' => 'Category already exists in this department']);
            exit;
        }

        // Query to insert category into the database
        $sql = "INSERT INTO category_header_all (dept_id, cat_name, cat_date_of_creation, cat_status) 
                VALUES ('$dept_id', '$cat_name', '$cat_date_of_creation', '$cat_status')";

        if (mysqli_query($conn, $sql)) {
            echo json_encode(['success_code' => 200, 'message' => 'Category added successfully']);
        } else {
            echo json_encode(['error_code' => 102, 'message' => 'Error adding category: ' . mysqli_error($conn)]);
        }
    } else {
        echo json_encode(['error_code' => 400, 'message' => 'Department and Category name are required']);
    }
} elseif ($_SERVER['REQUEST_METHOD'] == 'GET') {
    $conn = connection::getConnection();
    if (isset($_GET['action']) && $_GET['action'] == 'fetch_departments') {
        // Fetch departments
        $sql = "SELECT dept_id, dept_name FROM department_header_all";
        $result = mysqli_query($conn, $sql);

        $departments = [];
        while ($row = mysqli_fetch_assoc($result)) {
            $departments[] = $row;
        }
        echo json_encode($departments);
    } else {
        $dept_id = isset($_GET['dept_id']) ? (int)$_GET['dept_id'] : 0;
        $search = isset($_GET['search']) ? mysqli_real_escape_string($conn, $_GET['search']) : '';
        $currentPage = isset($_GET['page']) ? (int)$_GET['page'] : 1;

        // Query to get total category count for pagination with search
        if ($dept_id === '' || $dept_id == 0) {
            $totalCategoriesQuery = "SELECT COUNT(*) AS total FROM category_header_all WHERE cat_name LIKE '%$search%'";
        } else {
            $totalCategoriesQuery = "SELECT COUNT(*) AS total FROM category_header_all WHERE dept_id = '$dept_id' AND cat_name LIKE '%$search%'";
        }
        $totalCategoriesResult = mysqli_query($conn, $totalCategoriesQuery);
        $totalCategories = mysqli_fetch_assoc($totalCategoriesResult)['total'];
        $totalPages = ceil($totalCategories / $itemsPerPage);
        $currentPage = max(1, min($currentPage, $totalPages));
        $start = ($currentPage - 1) * $itemsPerPage;

        // Query to fetch categories for the current page with search
        if ($dept_id === '' || $dept_id == 0) {
            $sql = "SELECT c.cat_id, c.cat_name, c.cat_status, c.cat_date_of_creation, d.dept_name 
                    FROM category_header_all c 
                    JOIN department_header_all d ON c.dept_id = d.dept_id
                    WHERE c.cat_name LIKE '%$search%' LIMIT $start, $itemsPerPage";
        } else {
            $sql = "SELECT c.cat_id, c.cat_name, c.cat_status, c.cat_date_of_creation, d.dept_name 
                    FROM category_header_all c 
                    JOIN department_header_all d ON c.dept_id = d.dept_id
                    WHERE c.dept_id = '$dept_id' AND c.cat_name LIKE '%$search%' LIMIT $start, $itemsPerPage";
        }

        $result = mysqli_query($conn, $sql);

        $categories = [];
        if ($result && mysqli_num_rows($result) > 0) {
            while ($row = mysqli_fetch_assoc($result)) {
                $categories[] = $row;
            }
            echo json_encode([
                'success_code' => 200,
                'success' => true,
                'data' => $categories,
                'total_pages' => $totalPages,
                'current_page' => $currentPage
            ]);
        } else {
            echo json_encode(['error_code' => 101, 'message' => 'No categories found']);
        }
    }
} else {
    echo json_encode(['error_code' => 300, 'message' => 'Invalid request method']);
}
?>
