 // Date : 27-03-2025
    // Handle the response from the add_item API.

$(document).ready(function () {
    loadItems();

    // Fetch departments for the selection 
    $.ajax({
        url: './ajax/json_for_add_item_v1_0.php?action=fetch_departments',
        method: 'GET',
        success: function(response) {
            var departments = JSON.parse(response);
            departments.forEach(function(department) {
                $('#department_select').append(new Option(department.dept_name, department.dept_id));
            });

            // Load categories and subcategories
            var deptId = $('#department_select').val();
            if (deptId) {
                loadCategories(deptId);
            }
        }
    });

    // script for change department 
    $('#department_select').on('change', function() {
        var deptId = $(this).val();
        if (deptId) {
            loadCategories(deptId);
            //load items for that department only
            loadItems('', deptId);
        } else {
            // If no department is selected, load all items
            loadItems();
            // Clear the category and subcategory dropdowns
            $('#category_select').empty().append('<option value="">Select Category</option>');
            $('#subcategory_select').empty().append('<option value="">Select Subcategory</option>');
        }
    });

    // script for category change
    $('#category_select').on('change', function() {
        var catId = $(this).val();
        if (catId) {
            
            loadSubcategories(catId);
        } else {
            $('#subcategory_select').empty().append('<option value="">Select Subcategory</option>');
        }
    });

    // Function to load categories for selected department
    function loadCategories(deptId) {
        $.ajax({
            url: './ajax/json_for_add_item_v1_0.php?action=fetch_categories&dept_id=' + deptId,
            method: 'GET',
            success: function(response) {
                var categories = JSON.parse(response);
                $('#category_select').empty().append('<option value="">Select Category</option>');
                categories.forEach(function(category) {
                    $('#category_select').append(new Option(category.cat_name, category.cat_id));
                });

                $('#subcategory_select').empty().append('<option value="">Select Subcategory</option>');
            }
        });
    }

    // Function to load subcategories for selected category
    function loadSubcategories(catId) {
        $.ajax({
            url: './ajax/json_for_add_item_v1_0.php?action=fetch_subcategories&cat_id=' + catId,
            method: 'GET',
            success: function(response) {
                var subcategories = JSON.parse(response);
                $('#subcategory_select').empty().append('<option value="">Select Subcategory</option>');
                subcategories.forEach(function(subcategory) {
                    $('#subcategory_select').append(new Option(subcategory.sub_cat_name, subcategory.sub_cat_id));
                });
            }
        });
    }

    // Handle form submission to add item
    $('#addItemForm').on('submit', function(e) {
        e.preventDefault();

        var dept_id = $('#department_select').val();
        var cat_id = $('#category_select').val();
        var sub_cat_id = $('#subcategory_select').val();
        var item_name = $('#item_name').val();
        var drawing_no = $('#drawing_no').val();
        var part_no = $('#part_no').val();

        if (dept_id === "" || cat_id === "" || sub_cat_id === "" || item_name === "" || drawing_no === "" || part_no === "") {
            alert("All fields are required. Please fill in all fields.");
            return false;
        }

        var formData = {
            dept_id: dept_id,
            cat_id: cat_id,
            sub_cat_id: sub_cat_id,
            item_name: item_name,
            drawing_no: drawing_no,
            part_no: part_no
        };

        // AJAX request to add the item
        $.ajax({
            url: './ajax/json_for_add_item_v1_0.php',
            type: 'POST',
            data: formData,
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    alert(result.message);
                    $('#addItemForm')[0].reset();
                    loadItems(); 
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                alert("An error occurred while adding the item.");
            }
        });
    });

    // Function to load items with optional search query and department filter
    function loadItems(searchQuery = '', deptId = '', page = 1) {
        var data = {
            action: 'fetch_items',
            search: searchQuery,
            page: page
        };

        if (deptId) {
            data.dept_id = deptId;  
        }

        $.ajax({
            url: './ajax/json_for_add_item_v1_0.php',
            type: 'GET',
            data: data,
            success: function(response) {
                var result = JSON.parse(response);
                if (result.success) {
                    var items = result.data;
                    var tableBody = $('#itemList');
                    tableBody.empty(); // Clear existing rows
                    items.forEach(function(item) {
                        var row = '<tr>' +
                            '<td>' + item.item_name + '</td>' +
                            '<td>' + item.item_drawing_no + '</td>' +
                            '<td>' + item.item_part_no + '</td>' +
                            '<td>' + item.dept_name + '</td>' +
                            '<td>' + item.cat_name + '</td>' +
                            '<td>' + item.sub_cat_name + '</td>' +
                            '</tr>';
                        tableBody.append(row);
                    });

                    updatePagination(result.current_page, result.total_pages);
                } else {
                    alert(result.message);
                }
            },
            error: function(xhr, status, error) {
                console.error("Error fetching items: " + error);
            }
        });
    }

    // Update pagination controls
    function updatePagination(currentPage, totalPages) {
        const pagination = document.getElementById('pagination-links');
        pagination.innerHTML = ''; 

        if (totalPages <= 1) return;

        pagination.innerHTML += `  
            <li class="page-item ${currentPage === 1 ? 'disabled' : ''}">
                <a class="page-link" href="#" onclick="changePage(${currentPage - 1})"><<</a>
            </li>
        `;

        for (let i = 1; i <= totalPages; i++) {
            pagination.innerHTML += `  
                <li class="page-item ${i === currentPage ? 'active' : ''}">
                    <a class="page-link" href="#" onclick="changePage(${i})">${i}</a>
                </li>
            `;
        }

        pagination.innerHTML += `  
            <li class="page-item ${currentPage === totalPages ? 'disabled' : ''}">
                <a class="page-link" href="#" onclick="changePage(${currentPage + 1})">>></a>
            </li>
        `;
    }

    // Change page function for pagination
    window.changePage = function(page) {
        var searchQuery = $('#searchItem').val();
        var deptId = $('#department_select').val();
        loadItems(searchQuery, deptId, page);
    };
});
