const getAllRequisitionHeaderWithStatus = () => {
  

    $.ajax({
        url: "./ajax/json_for_dashboard_v1_0.php",
        type: "POST",
        dataType: "json",
        contentType: "application/x-www-form-urlencoded", // Explicitly setting content type
        headers: {
            "mode":"1"
        },
        success: function (response) {
            if (response.error_code === 200) {

                console.log(response);
                const statusCounts = response.status_counts;
                const data = response.data;

                // Map of status keys to corresponding element IDs
                const statusMap = {
                    "partial": "partilal",
                    "pending": "pending",
                    "accepted": "accepted",
                    "rejected": "cancel",
                    "return": "return",
                    "operative": "operational",
                    "complete": "complete"
                };
        
                // Loop through the status counts and update the respective elements
                for (const [status, id] of Object.entries(statusMap)) {
                    const element = document.getElementById(id);
                    if (element) {
                        element.textContent = statusCounts[status] || 0;
                    }
                }


                const todoList = document.getElementById("scroll-list");
                todoList.innerHTML = ""; // Clear previous items
            
                data.forEach(req => {
                    const formattedDate = new Date(req.req_date_of_creation).toLocaleDateString("en-GB", {
                        day: "2-digit",
                        month: "long",
                        year: "numeric"
                    });
            
                    let statusBadgeClass = '';
                    let statusText = '';

                    switch (parseInt(req.req_status)) {
                        case 1:
                            statusText = "partial";
                            statusBadgeClass = "badge-opacity-warning"; 
                            break;
                        case 2:
                            statusText = "pending";
                            statusBadgeClass = "badge-opacity-info"; 
                            break;
                        case 3:
                            statusText = "accepted";
                            statusBadgeClass = "badge-opacity-success"; 
                            break;
                        case 4:
                            statusText = "rejected";
                            statusBadgeClass = "badge-opacity-danger"; 
                            break;
                        case 5:
                            statusText = "return";
                            statusBadgeClass = "badge-opacity-primary"; 
                            break;
                        case 6:
                            statusText = "operative";
                            statusBadgeClass = "badge-opacity-secondary"; 
                            break;
                        default:
                            statusText = "complete";
                            statusBadgeClass = "badge-opacity-dark"; 
                    }

                    const listItem = `
                        <li class="d-block">
                            <div class="form-check w-100">
                                <label class="form-check-label">
                                    <input class="checkbox" type="checkbox" data-req-no="${req.req_no}"> 
                                    Requisition No: ${req.req_no} 
                                    <i class="input-helper rounded"></i>
                                </label>
                                <div class="d-flex mt-2">
                                    <div class="ps-4 text-small me-3">${formattedDate}</div>
                                    <div class="badge ${statusBadgeClass} me-3">${statusText}</div>
                                    ${req.req_status == 5 ? '<i class="mdi mdi-flag ms-2 flag-color"></i>' : ''}
                                </div>
                            </div>
                        </li>
                    `;
            
                    todoList.innerHTML += listItem;
                });




            } else {
                alert('Error: ' + response.message);
            }
        },
        error: function (xhr, status, error) {
            console.log("AJAX Error: ", status, error);
            console.log("Response Text: ", xhr.responseText);
            alert("Server error. Please check the console.");
        }
    });
};