<?php
$page = isset($_GET['page']) ? $_GET['page'] : 'dashboard';
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Kaizen Ship Management</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">

    <style>
        body {
            margin: 0;
            font-family: "Segoe UI", Tahoma, Geneva, Verdana, sans-serif;
            background-color:#f8f9fa;
        }

        /* Sidebar Styles */
        .sidebar {
            width: 230px;
            height: 100vh;
            background-color:rgb(0, 0, 0);
            position: fixed;
            top: 0;
            left: 0;
            color: #fff;
            padding-top: 60px;
            transition: all 0.3s ease;
        }

        .sidebar a {
            color: #fff;
            display: flex;
            align-items: center;
            padding: 10px 20px;
            text-decoration: none;
        }

        .sidebar a .icon {
            margin-right: 15px;
        }

        .sidebar a:hover {
            background-color: #1a2226;
        }

        .content-wrapper {      
            margin-left: 250px;
            padding: 20px;
        }

        /* Navbar Styles */
        .navbar-custom {
            background-color: #21a9bc; 
            color: #fff;
            padding: 6px 20px;
            z-index: 1000; 
            position: relative;
        }

        .navbar-custom .navbar-brand {
            color: #fff;
            font-size: 17px;
            font-weight: bold;
            text-align: center;
            flex: 1;
        }

        .navbar-custom .profile-avatar {
            width: 25px;
            height: 25px;
            background-color: #fff;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
            font-size: 17px;
            box-shadow: 0 0 8px rgba(0,0,0,0.3);
            margin-left: 10px;
        }

        /* Style for disabled links */
        a.disabled {
            pointer-events: none;  
            color: grey;           
            text-decoration: none; 
        }

        a.enabled {
            color: gray;  
        }

        a:hover {
            color: white;  
        }

        .additional-content {
            display: none;
        }

        /* Sidebar collapse */
        .sidebar.collapsed {
            width: 50px; 
        }

        .sidebar.collapsed a {
            justify-content: center;
        }

        .sidebar.collapsed a .text {
            display: none;
        }

        .sidebar.collapsed a .icon {
            font-size: 15px;
        }
    </style>
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-custom">
    <div class="navbar" id="toggle-sidebar" style="cursor: pointer; margin-left: 10px; display: flex; align-items: center; color: white;">
        <i class="fa fa-bars"></i>
    </div>
    <span style="font-weight:bold; margin-left:20px; font-size:20px;">KSM</span>
    <a class="navbar-brand mx-auto">KAIZEN SHIP MANAGEMENT</a>
    <div class="profile-avatar">
        <i class="fa fa-user"></i>
    </div>
    <span style="color: #fff; margin-left: 10px; align-self: center;font-size: 14px;">Gaurav Maithil</span>
</nav>

<!-- Sidebar -->
<div id="sidebar" class="sidebar">
    <a class="disabled"><span class="text" style="font-size: 13px;"> MAIN NAVIGATION</span>
    </a>
    <a href="#" class="enabled">
        <i class="fa fa-dashboard icon"></i><span class="text" style="font-size: 13px;"> Dashboard</span>
    </a>
    <a href="#" class="enabled" id="operational-section">
        <i class="fa fa-copy icon"></i><span class="text" style="font-size: 13px;"> Operational Section</span>
    </a>
    <div id="operational-content" class="additional-content" style="padding-left: 20px;">
        <a href="tree.php?userName=Admin1&userPassword=Admin@123" target="_blank" class="enabled">
            <i class="fa fa-shopping-cart icon"></i><span class="text" style="font-size: 13px;"> Purchase Access</span>
        </a>
        <a href="#" class="disabled">   
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> HRM F 506</span>
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> HRM F 501</span>
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> HRM F 502</span>
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> Crew Particulars</span>
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> HRM F 503</span>      
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> HRM F 504</span>
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> HRM F 505</span>
        </a>
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> Vessel Assign Approval</span>
        </a>
    </div>
    <a href="#" class="enabled" id="vims-section">
        <i class="fa fa-file icon"></i><span class="text" style="font-size: 13px;">VIMS</span>
    </a>
    <div id="vims-content" class="additional-content" style="padding-left: 20px;">
        <a href="#" class="disabled">
            <i class="fa fa-circle-dot icon"></i><span class="text" style="font-size: 13px;"> Vessel Position</span>
        </a>
    </div>
</div>

<div class="content-wrapper">
    <?php if ($page == 'dashboard') : ?>
        <div class="info-message">
            <strong>Note:</strong> To access the purchase module, please select the "Purchase Access" option from the "Operational Section" tab in the sidebar.
        </div>
    <?php endif; ?>
</div>


<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

<script>
    document.getElementById('toggle-sidebar').addEventListener('click', function() {
        const sidebar = document.getElementById('sidebar');
        sidebar.classList.toggle('collapsed');
    });

    document.getElementById('operational-section').addEventListener('click', function() {
        const operationalContent = document.getElementById('operational-content');
        operationalContent.style.display = operationalContent.style.display === 'none' || operationalContent.style.display === '' ? 'block' : 'none';
    });

    document.getElementById('vims-section').addEventListener('click', function() {
        const vimsContent = document.getElementById('vims-content');
        vimsContent.style.display = vimsContent.style.display === 'none' || vimsContent.style.display === '' ? 'block' : 'none';
    });
</script>

</body>
</html>
