<?php
/*
File: json_for_requisition_details_v1_0.php
Purpose: Fetch item details for a specific requisition ID (req_id)
Created: 13/05/2025
*/

session_start();
require_once("../config/config.php");

header('Content-Type: application/json');

$conn = SqlServerConnection::getConnection();

$req_id = isset($_POST['req_id']) ? $_POST['req_id'] : null;

if (!$req_id) {
    echo json_encode([
        "error_code" => 400,
        "message" => "Missing requisition ID"
    ]);
    exit;
}

$items = [];
$item_sql = "SELECT * FROM item_requisition_header_all WHERE req_id = ?";
$item_stmt = sqlsrv_query($conn, $item_sql, [$req_id]);

if (!$item_stmt) {
    echo json_encode([
        "error_code" => 500,
        "message" => "Error fetching item requisition data."
    ]);
    exit;
}

while ($item_row = sqlsrv_fetch_array($item_stmt, SQLSRV_FETCH_ASSOC)) {
    for ($i = 1; $i <= 40; $i++) {
        $item_id_key = "item_id_$i";
        $item_details_key = "item_details_$i";

        $item_id = $item_row[$item_id_key];
        $item_details_json = $item_row[$item_details_key];

        if (!empty($item_id) && !empty($item_details_json)) {
            $item_details = json_decode($item_details_json, true);

            $item_info_stmt = sqlsrv_query(
                $conn,
                "SELECT item_id, item_name, item_drawing_no, item_part_no FROM item_header_all WHERE item_id = ?",
                [$item_id]
            );

            $item_info = sqlsrv_fetch_array($item_info_stmt, SQLSRV_FETCH_ASSOC);

            $items[] = [
                "item_id" => $item_id,
                "item_name" => $item_info['item_name'] ?? '',
                "item_drawing_no" => $item_info['item_drawing_no'] ?? '',
                "item_part_no" => $item_info['item_part_no'] ?? '',
                "working_qty" => $item_details['working_qty'] ?? '',
                "rob" => $item_details['rob'] ?? '',
                "req_qty" => $item_details['req_qty'] ?? '',
                "remark" => $item_details['remark'] ?? ''
            ];
        }
    }
}

echo json_encode([
    "error_code" => 200,
    "data" => $items
]);

?>