<?php
session_start();

require_once("../config/config.php");
header('Content-Type: application/json'); 

$response = ['status' => 'error', 'message' => 'Unknown error occurred'];

$requisition_id = $_SESSION['requisition_no'] ?? 0;
if ($requisition_id == 0) {
    $response['message'] = 'Requisition ID is missing from session';
    echo json_encode($response);
    exit;
}

if (!$conn) {
    $response['message'] = 'Database connection failed: ' . mysqli_connect_error();
    echo json_encode($response);
    exit;
}

$allCookies = $_COOKIE['shipRequestedItems'] ?? '';
if (!$allCookies) {
    $response['message'] = 'No items found in cookie';
    echo json_encode($response);
    exit;
}

$itemsData = json_decode($allCookies, true);
if (!is_array($itemsData)) {
    $response['message'] = 'Invalid cookie data format';
    echo json_encode($response);
    exit;
}

foreach ($itemsData as $sub_category_id => $subCategory) {
    $categoryName = $subCategory['categoryName'];
    $items = $subCategory['items'];

    $category_id = 0;
    $query = "SELECT id, category_id FROM ship_requisition_header_all WHERE requisition_no = '" . mysqli_real_escape_string($conn, $requisition_id) . "'";
$result = mysqli_query($conn, $query);

if ($row = mysqli_fetch_assoc($result)) {
    $requisition_id_main = $row['id'];          // This is the correct FK
    $category_id = $row['category_id'];     // Needed for item insert
}else {
        $response['message'] = "Category not found: $categoryName";
        echo json_encode($response);
        exit;
    }

    foreach ($items as $item) {
        $item_id = $item['id'];
        $working_qry = $item['wQty'];
        $rob = $item['rob'];
        $required_qty = $item['reqQty'];
        $remarks = mysqli_real_escape_string($conn, $item['remark']);

       $insertQuery = "
        INSERT INTO ship_requisition_items (requisition_id, category_id, sub_category_id, item_id, working_qry, rob, required_qty, remarks)
        VALUES (
            '" . mysqli_real_escape_string($conn, $requisition_id_main) . "',
            '" . mysqli_real_escape_string($conn, $category_id) . "',
            '" . mysqli_real_escape_string($conn, $sub_category_id) . "',
            '" . mysqli_real_escape_string($conn, $item_id) . "',
            '" . mysqli_real_escape_string($conn, $working_qry) . "',
            '" . mysqli_real_escape_string($conn, $rob) . "',
            '" . mysqli_real_escape_string($conn, $required_qty) . "',
            '$remarks'
        )
    ";
    

        if (!mysqli_query($conn, $insertQuery)) {
            $response['message'] = 'Error inserting item: ' . mysqli_error($conn);
            echo json_encode($response);
            exit;
        } else {

            $query_for_change_status = "UPDATE ship_requisition_header_all SET status = 0 WHERE id = $requisition_id_main";
            $result_for_change_status = mysqli_query($conn, $query_for_change_status);


            // $query_for_tracker = "INSERT INTO tracker_header_all (requisition_id, generated_on)
            // VALUES ($requisition_id_main, NOW())";
            // mysqli_query($conn, $query_for_tracker);
        }
    }
}

$response = ['status' => 'success', 'message' => 'All items successfully inserted'];
echo json_encode($response);
mysqli_close($conn);
?>