<?php

class SqlServerConnection {
    private static $conn = null;

    private static $serverName = "localhost"; //also use "SERVERNAME\\SQLEXPRESS" 

    private static $connectionOptions = [
        // "Database" => "kaizen_ship_management",
        "Database" => "kaizen_ship_management_new",
        // "UID" => "your_username",          
        // "PWD" => "your_password",           
        "CharacterSet" => "UTF-8",
        "TrustServerCertificate" => true    
    ];

    private function __construct() {
        if (self::$conn === null) {
            self::$conn = sqlsrv_connect(self::$serverName, self::$connectionOptions);

            if (self::$conn === false) {
                error_log("SQL Server connection failed: " . print_r(sqlsrv_errors(), true));
                die("SQL Server connection error.");
            }
        }
    }

    public static function getConnection() {
        if (self::$conn === null) {
            new self();
        }
        return self::$conn;
    }

    public static function closeConnection() {
        if (self::$conn !== null) {
            sqlsrv_close(self::$conn);
            self::$conn = null;
        }
    }
}
?>
