// const { connectToDb, sql } = require('../../dbConfig/db'); // For MSSQL, can be removed if not used
const { json } = require('express');
const { pool } = require('../../dbConfig/db'); // For MySQL
const { format } = require('date-fns');

// GET all job types
async function getJobs() {

    // for MySQL
    try {
        const [rows] = await pool.query('SELECT * FROM job_type_header_all');
        const formattedJobs = rows.map(row => {
            return {
                ...row,
                JTH_time_limit: format(new Date(row.JTH_time_limit), 'yyyy-MM-dd'),
            };
        });
        return formattedJobs;
    } catch (err) {
        console.error('❌ MySQL Error:', err);
        throw err;
    }
}

// ADD a new job
async function addJob(data) {
    const { JTH_ID, JTH_job_type, JTH_job_short_name, JTH_time_limit, JTH_status } = data;

    // for MySQL
    try {
        const statusValue = Buffer.isBuffer(JTH_status) ? JTH_status[0] : JTH_status;
        await pool.query(
            `INSERT INTO job_type_header_all 
            (JTH_ID, JTH_job_type, JTH_job_short_name, JTH_time_limit, JTH_status) 
            VALUES (?, ?, ?, ?, ?)`,
            [JTH_ID, JTH_job_type, JTH_job_short_name, JTH_time_limit, statusValue]
        );
    } catch (err) {
        console.error('❌ MySQL Error while Inserting Job Type :', err);
        throw err;
    }
}

// UPDATE job
async function updateJob(data) {
    const { JTH_ID, JTH_job_type, JTH_job_short_name, JTH_time_limit, JTH_status } = data;


    // for MySQL
    try {
        const statusValue = Buffer.isBuffer(JTH_status) ? JTH_status[0] : JTH_status;
        await pool.query(
            `UPDATE job_type_header_all
             SET JTH_job_type = ?, JTH_job_short_name = ?, JTH_time_limit = ?, JTH_status = ?
             WHERE JTH_ID = ?`,
            [JTH_job_type, JTH_job_short_name, JTH_time_limit, statusValue, JTH_ID]
        );
    } catch (err) {
        console.error('❌ MySQL Update Error:', err);
        throw err;
    }
}

// DELETE job
async function deleteJob(JTH_ID) {

    // for MySQL
    try {
        await pool.query(
            `DELETE FROM job_type_header_all WHERE JTH_ID = ?`,
            [JTH_ID]
        );
    } catch (err) {
        console.error('❌ MySQL Delete Error:', err);
        throw err;
    }
}

module.exports = {
    getJobs,
    addJob,
    updateJob,
    deleteJob
};